
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = [10, 30, 60, 90, 150]
y = [6.4, 7.1, 6.8, 7.5, 7.2]
x2 = [70]
y2 = [8.1]

# Labels and Plot Types
label_Budget_Rating = "Movie Ratings"
label_Highlight = "Special Highlight"
ax1_txt = [
    "6.4\nAction",
    "7.1\nDrama",
    "6.8\nComedy",
    "7.5\nThriller",
    "7.2\nSci-Fi",
]
ax2_txt = "8.1\nHit Movie"

# Axes Limits and Labels
xlabel_value = "Movie Budget (M)"
ylabel_value = "Movie Rating"
xticklabels1 = [str(num) for num in x]
ylim_values = [6.0, 8.5]
yticks_values = [6.0, 6.5, 7.0, 7.5, 8.0]
xlim_values = [0, 160]
xticks_values = [0, 50, 100, 150]
xticklabels2 = ["0", "50", "100", "150"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Plot the data
ax.plot(x, y, 'o--', color='purple', label=label_Budget_Rating, linewidth=2, markersize=8)
ax.plot(x2, y2, 'v', color='green', markersize=10, label=label_Highlight)

# Annotate the points
for i, txt in enumerate(ax1_txt):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
        color='black'
    )
ax.annotate(
    ax2_txt,
    (x2[0], y2[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title("Movie Budget vs. Rating", fontsize=14)

# Set the legend
legend = ax.legend(fontsize=12)

# Adjust x-axis labels
ax.set_xticks(x)
ax.set_xticklabels(xticklabels1, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_98.pdf", bbox_inches="tight")
