
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new data for stock prices
days = [0, 10, 20, 30, 40, 50]
stock_A_prices = [150, 155, 160, 158, 162, 170]
stock_B_prices = [120, 118, 125, 123, 128, 130]

# Single data point for stock B
important_day = [30]
important_price = [123]

# Labels and Plot Types
label_stock_A = "Stock A"
label_stock_B = "Stock B"
annotations_A = [
    "150\nStart",
    "155\nRise",
    "160\nPeak",
    "158\nDip",
    "162\nClimb",
    "170\nEnd",
]
annotation_B = "123\nSignificant Drop"

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Stock Price (USD)"
xticklabels1 = [str(day) for day in days]
ylim_values = [110, 180]
yticks_values = np.arange(110, 181, 10)
xlim_values = [-5, 55]
xticks_values = [0, 10, 20, 30, 40, 50]
xticklabels2 = ["0", "10", "20", "30", "40", "50"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data
ax.plot(days, stock_A_prices, "g^-", label=label_stock_A, linewidth=2, markersize=8)
ax.plot(important_day, important_price, "r*--", markersize=12, label=label_stock_B)

# Annotate the points for Stock A
for i, txt in enumerate(annotations_A):
    ax.annotate(
        txt,
        (days[i], stock_A_prices[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
# Annotate the single important point for Stock B
ax.annotate(
    annotation_B,
    (important_day[0], important_price[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title("Stock Price Analysis", fontsize=14)

# Set the legend
legend = ax.legend(fontsize=10)

# Adjust x-axis labels
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_99.pdf", bbox_inches="tight")
