
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.image import NonUniformImage

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
interp = "nearest"

# Time array
time = np.linspace(0, 10, 100)
# Simulate media metrics (e.g., user engagement) with sinusoidal variations
engagement = np.sin(time) * np.exp(-time/3)
engagement2 = np.cos(time) * np.exp(-time/3)

# Using a highly nonlinear transformation for variety
time2 = time ** 1.5

# Z values, simulating engagement metrics in a grid
x = np.linspace(-4, 4, 100)
y = np.linspace(-4, 4, 100)
z = np.sin(x[np.newaxis, :]**2 + y[:, np.newaxis]**2)
title=["Sinusoidal Engagement (nearest)","Transformed Engagement (nearest)"]
suptitle = "User Engagement Over Time"
xlabel = "Time (days)"
ylabel = "Engagement Level"
xlim = [[0, 10], [0, 31.6], [0, 10], [0, 31.6]]
ylim = [[-1, 1], [-1, 1], [-1, 1], [-1, 1]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(10, 8))
fig.suptitle(suptitle, fontsize="large")

ax = axs[0, 0]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[0][0], xlim[0][1], ylim[0][0], ylim[0][1]),
    cmap=cm.coolwarm,
)
im.set_data(time, engagement, z)
ax.add_image(im)
ax.set_xlim(xlim[0])
ax.set_ylim(ylim[0])
ax.set_title(title[0])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax = axs[0, 1]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[1][0], xlim[1][1], ylim[0][0], ylim[0][1]),
    cmap=cm.coolwarm,
)
im.set_data(time2, engagement2, z)
ax.add_image(im)
ax.set_xlim(xlim[1])
ax.set_ylim(ylim[1])
ax.set_title(title[1])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

interp = "bilinear"

ax = axs[1, 0]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[2][0], xlim[2][1], ylim[2][0], ylim[2][1]),
    cmap=cm.coolwarm,
)
im.set_data(time, engagement, z)
ax.add_image(im)
ax.set_xlim(xlim[2])
ax.set_ylim(ylim[2])
ax.set_title("Sinusoidal Engagement (bilinear)")
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax = axs[1, 1]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[3][0], xlim[3][1], ylim[3][0], ylim[3][1]),
    cmap=cm.coolwarm,
)
im.set_data(time2, engagement2, z)
ax.add_image(im)
ax.set_xlim(xlim[3])
ax.set_ylim(ylim[3])
ax.set_title("Transformed Engagement (bilinear)")
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_100.pdf", bbox_inches="tight")
