
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Define the bubble sizes and colors for each task
bubble_sizes = {100: 300, 75: 250, 50: 200, 25: 150, 0: 50}

label2idx = {"Infrastructure": 0, "Population": 1, "Technology": 2, "Community": 3}
idx2label = {v: k for k, v in label2idx.items()}

data = {
    "UA": {
        "Infrastructure": [100, 75, 50, 25],
        "Population": [100, 75, 50, 25],
        "Technology": [100, 75, 50, 25],
        "Community": [100, 75, 50, 25],
    },
    "SA": {
        "Infrastructure": [25, 50, 75, 100],
        "Population": [25, 50, 100, 75],
        "Technology": [25, 100, 50, 75],
        "Community": [100, 50, 75, 25],
    },
    "RA": {
        "Infrastructure": [0, 25, 50, 75],
        "Population": [0, 25, 50, 75],
        "Technology": [0, 25, 50, 75],
        "Community": [0, 25, 50, 75],
    },
    "DA": {
        "Infrastructure": [50, 25, 75, 0],
        "Population": [75, 50, 25, 0],
        "Technology": [25, 75, 0, 50],
        "Community": [75, 25, 0, 50],
    },
}

title = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4), sharey=True)
colors = {0: "#ff9999", 1: "#66b3ff", 2: "#99ff99", 3: "#ffcc99"}
# Loop through each subplot and plot the data
for i, (title, metrics) in enumerate(data.items()):
    ax = axs[i % 4]
    ax.set_title(title)

    for metric, values in metrics.items():
        ax.scatter(
            x=range(len(values)),
            y=[label2idx[metric]] * len(values),
            s=[bubble_sizes[_] for _ in values],
            c=colors[label2idx[metric]],
            label=metric,
            alpha=0.75,
            edgecolors='w',
            linewidth=0.5,
        )
        for j, v in enumerate(values):
            ax.text(j, label2idx[metric], str(v), ha="center", va="center", fontsize=8)
    ax.set_xticks(range(len(values)))
    ax.set_xticklabels([chr(65+i) for i in range(len(values))])
    ax.set_xlim(-0.5, len(values) - 0.5)
    ax.set_ylim(-0.5, len(label2idx) - 0.5)
    ax.set_yticks(range(len(label2idx)))
    ax.set_yticklabels([idx2label[i] for i in range(len(label2idx))])
    ax.set_xlabel("Client")

fig.suptitle("Regional Development Metrics", fontsize=14)

# Add the legend
handles, labels = axs[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=4,
    markerscale=0.75,
    fontsize="small",
    bbox_to_anchor=(0.5, -0.1),
    title=title,
    title_fontsize="medium",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("HR_26.pdf", bbox_inches="tight")
