
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib.colors as colors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Function to draw ellipses with varying radii and colors
xlim = [-10, 10]
ylim = [-5, 5]
xlabel = "Annual Risk (%)"
ylabel = "Annual Return (%)"
title = "Risk vs. Return for Financial Portfolios"
num_ellipses = 12
a_start = 1
b_start = 0.5
a_end = 8
b_end = 3
color_label = "Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

def draw_colored_ellipses(num_ellipses, a_start, b_start, a_end, b_end):
    t = np.linspace(0, 2 * np.pi, 100)
    fig, ax = plt.subplots(figsize=(8, 6))

    # Create a colormap
    cmap = cm.get_cmap('viridis', num_ellipses)
    norm = colors.BoundaryNorm(np.arange(num_ellipses + 1), cmap.N)

    for i in range(num_ellipses):
        # Interpolate the semi-major and semi-minor axes
        a = np.linspace(a_start, a_end, num_ellipses)[i]
        b = np.linspace(b_start, b_end, num_ellipses)[i]

        # Parametric equations for the ellipse
        x = a * np.cos(t)
        y = b * np.sin(t)

        # Use a colormap to determine the color
        color = cmap(i)
        ax.set_xlim(xlim)
        ax.set_ylim(ylim)
        ax.plot(x, y, color=color, linewidth=1.5)
        ax.set_xlabel(xlabel)
        ax.set_ylabel(ylabel)

    # Central elliptical trend line
    x_center = 1.2 * np.cos(t)
    y_center = 1.5 * np.sin(t)
    ax.plot(x_center, y_center, color="black", linestyle='--', linewidth=2)

    # Set the same scaling for both axes
    ax.set_aspect('equal')
    # Create a mappable object for the colorbar
    sm = cm.ScalarMappable(cmap=cmap, norm=norm)
    sm.set_array([])

    # Add the colorbar
    cbar = plt.colorbar(sm, ticks=np.arange(0.5, num_ellipses, 1), label=color_label, ax=ax)
    cbar.set_ticklabels(np.arange(num_ellipses))  # set tick labels from 0 to num_ellipses-1
    cbar.ax.tick_params(length=0)

    # Add title and additional adjustments
    ax.set_title(title)
    plt.tight_layout()

# Show the plot
draw_colored_ellipses(num_ellipses=num_ellipses, a_start=a_start, b_start=b_start, a_end=a_end, b_end=b_end)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("HR_30.pdf", bbox_inches="tight")
