
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Tech Market Trends
bits = np.arange(14)
market_trend_a = np.array(
    [350, 330, 320, 520] + sorted(list(np.random.randint(300, 500, 10)))
)
market_trend_b = np.array(
    [360, 340, 315, 520] + sorted(list(np.random.randint(300, 500, 10)))
)
trend_projection = [sorted(np.random.randint(200, 500, 10), reverse=True) for i in range(2)]

# Creating an array of bits to adjust spacing for the bars
adjusted_bits = np.array(bits, dtype=float)
# Adjust spacing for purple and the three bars before it
adjusted_bits[3] += 0.5
# Adjust spacing between the red/blue bars and the others
adjusted_bits[4:] += 4
title = "Tech Market - Trend A"
xlabel = "Months"
ylabel = "Market Value"
ylim = [0, 550]
axhline = 520

title2 = "Tech Market - Trend B"
xlabel2 = "Months"
ylabel2 = "Market Value"
ylim2 = [0, 550]
axhline2 = 520
xticks = adjusted_bits[4:]
xtickslabel = np.arange(0, 10)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image dimensions
tech_colors_a = [plt.cm.Greens(i) for i in np.linspace(0.6, 0.3, 10)]
tech_colors_b = [plt.cm.Oranges(i) for i in np.linspace(0.4, 0.7, 10)]

plt.figure(figsize=(12, 5))

# Subplot 1: Tech Market - Trend A
plt.subplot(1, 2, 1)
plt.bar(
    adjusted_bits[:4],
    market_trend_a[:4],
    color=["#0a74da", "#f39c12", "#2ecc71", "#8e44ad"],
)
plt.bar(adjusted_bits[4:], market_trend_a[4:], color=tech_colors_a)
plt.bar(adjusted_bits[4:], trend_projection[0], width=0.5, color=tech_colors_b)
plt.title(title, y=-0.3)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline, linestyle="dotted", color="black")

# Subplot 2: Tech Market - Trend B
plt.subplot(1, 2, 2)
plt.bar(
    adjusted_bits[:4],
    market_trend_b[:4],
    color=["#0a74da", "#f39c12", "#2ecc71", "#8e44ad"],
)
plt.bar(adjusted_bits[4:], market_trend_b[4:], color=tech_colors_a)
plt.bar(adjusted_bits[4:], trend_projection[1], width=0.5, color=tech_colors_b)
plt.title(title2, y=-0.3)
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.ylim(ylim2)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline2, linestyle="dotted", color="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("HR_34.pdf", bbox_inches="tight")
