
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate time slots (hours of the day)
time_slots = np.linspace(0, 24, 100)
# Simulate user engagement levels for different categories
engagement_news = 0.15 - 0.002 * (time_slots - 12) ** 2
engagement_entertainment = 0.1 - 0.0015 * (time_slots - 14) ** 2
engagement_education = 0.08 - 0.001 * (time_slots - 10) ** 2
engagement_sports = 0.12 - 0.0018 * (time_slots - 18) ** 2
engagement_social_media = 0.09 - 0.0013 * (time_slots - 16) ** 2

# Simulate user preference matrix
News = np.random.rand(3, 10) * 10
Entertainment = np.random.rand(2, 10) * 10
Education = np.random.rand(4, 10) * 10
Sports = np.random.rand(3, 10) * 10
SocialMedia = np.random.rand(2, 10) * 10

# Sort simulated engagement data
News = [sorted(n, reverse=True) for n in News]
Entertainment = [sorted(e, reverse=True) for e in Entertainment]
Education = [sorted(edu, reverse=True) for edu in Education]
Sports = [sorted(s) for s in Sports]
SocialMedia = [sorted(sm) for sm in SocialMedia]

# Label parameters
xlabel = "Time (Hours)"
ylabel = "Engagement Level"
title = "User Engagement in Media Categories"
baseline = 0
labels = ["News", "Entertainment", "Education", "Sports", "Social Media"]
textheight = 9.5
xlabel2 = "Segments"
ylabel2 = "Time Slots"
title2 = "User Preference Matrix"
plotlabels = ["News", "Entertainment", "Education", "Sports", "Social Media"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# New color scheme for media visualization
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

# Create the left plot (User Engagement in Media Categories)
plt.subplot(1, 2, 1)
plt.plot(time_slots, engagement_news, label=plotlabels[0], color=colors[0], linestyle='-', linewidth=2)
plt.plot(time_slots, engagement_entertainment, label=plotlabels[1], color=colors[1], linestyle='--', linewidth=2)
plt.plot(time_slots, engagement_education, label=plotlabels[2], color=colors[2], linestyle='-.', linewidth=2)
plt.plot(time_slots, engagement_sports, label=plotlabels[3], color=colors[3], linestyle=':', linewidth=2)
plt.plot(time_slots, engagement_social_media, label=plotlabels[4], color=colors[4], linestyle=(0, (3, 1, 1, 1)), linewidth=2)

plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Create the right plot (User preference matrix)
plt.subplot(1, 2, 2)

for index, values in enumerate([News, Entertainment, Education, Sports, SocialMedia]):
    for i in range(len(values)):
        plt.scatter(
            [baseline + i] * len(values[i]),
            range(len(values[i])),
            s=values[i],
            c=colors[index],
            marker='o' if index % 2 == 0 else '^'
        )
    plt.text(baseline + len(values) / 2, textheight, labels[index],fontsize=8)
    baseline = baseline + len(values)

for spine in plt.gca().spines.values():
    spine.set_visible(False)

plt.xticks([])
plt.yticks([])
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.title(title2, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("HR_45.pdf", bbox_inches="tight")
