
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Parallelogram boundary points representing travel modes
boundary_points = np.array([[0, 0], [5, 2], [6, 6], [1, 4]])

# Simulate data for different transportation modes
data_cars = np.random.normal(loc=3, scale=1, size=(100000, 2))  # Cars
data_bikes = np.random.normal(loc=2, scale=0.5, size=(1000, 2))  # Bikes
data_buses = np.random.normal(loc=4, scale=0.8, size=(1000, 2))  # Buses

# Labels and configuration
ylabel = [
    "Monthly Car Travel (km)",
    "Monthly Bike Travel (km)",
    "Monthly Bus Travel (km)",
]
xlabel = "Monthly Distance (km)"
labels = ["A", "B", "C", "D"]
xlim = [-1, 7]
ylim = [-1, 7]
legendtitle = "num. of points = {}"
title = "Monthly Travel Distances for Different Transportation Modes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(12, 5))

# Use new colors
colors = ["#FF9999", "#66B2FF", "#99FF99"]
boundary_color = "#FFCC99"

# Create subplots
for i, (data, mode_color) in enumerate(zip([data_cars, data_bikes, data_buses], colors), 1):
    ax = fig.add_subplot(1, 3, i)
    # Fill the parallelogram with a new color
    ax.fill(boundary_points[:, 0], boundary_points[:, 1], color=boundary_color, alpha=0.5)
    ax.set_xlim(xlim)
    ax.set_ylim(ylim)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel[i - 1])
    if i != 1:
        ax.set_yticks([])

    for point, label in zip(boundary_points, labels):
        ax.text(point[0] + 0.1, point[1] + 0.1, label, color="black", fontsize=8)
    
    scatter = ax.scatter(data[:, 0], data[:, 1], color=mode_color, s=1)
    ax.legend([scatter], [legendtitle.format(len(data))], loc="upper right")
    ax.plot(
        np.append(boundary_points[:, 0], boundary_points[0, 0]),
        np.append(boundary_points[:, 1], boundary_points[0, 1]),
        color="blue",
    )

fig.suptitle(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("HR_47.pdf", bbox_inches="tight")
