
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility

# Data representing calorie intake vs. exercise performance for different age groups
calories_per_minute = [0.5, 15]
performance = [1500, 7500]

# Points (age groups: 20s, 30s, 40s, 50s, 60s, 70s)
points_x = [2, 3, 4, 5, 6, 7]
points_y = [5000, 4700, 4500, 4200, 3900, 3600]
labels = [
    "20s",
    "30s",
    "40s",
    "50s",
    "60s",
    "70s",
]

markers = ["o", "s", "D", "v", "^", "p"]
axlines = [
    [[0.5, 20], [7500, 7500]],
    [[2, 20], [4000, 4000]],
    [[1, 20], [1500, 1500]],
]
x_fill = [0.5, 15, 20, 20]
y_fill_top = [1500, 7500, 7500, 7500]
y_fill_bottom = [1000, 1000, 1000, 1000]
xlabel = "Calories Burned per Minute"
ylabel = "Exercise Performance (arbitrary units)"
xlim = [0.5, 20]
ylim = [1000, 8000]
textlabels = ["Minimum Performance", "Peak Performance", "Healthy Range"]
textposition = [[1, 2000], [15, 7800], [15, 4200]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["forestgreen", "dodgerblue", "goldenrod", "firebrick", "mediumorchid", "brown"]
# Plot the health performance model
ax.plot(calories_per_minute, performance, color="black", linestyle="--", linewidth=2)

# Adding horizontal performance lines
for line in axlines:
    ax.plot(line[0], line[1], color="grey", linestyle=":")

ax.fill_between(x_fill, y_fill_top, y_fill_bottom, color="lightgreen", alpha=0.3)

# Add text annotations
for pos, label in zip(textposition, textlabels):
    ax.text(
        pos[0], pos[1], label, rotation=0, verticalalignment="bottom", horizontalalignment="center", fontsize=10
    )

# Plot the points
for x, y, label, color, marker in zip(points_x, points_y, labels, colors, markers):
    ax.plot(x, y, label=label, color=color, marker=marker, markersize=10)

# Set scale to log
ax.set_xscale("log")
ax.set_yscale("log")

# Set labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add legend
ax.legend(title="Age Groups", loc="lower left", fontsize=10)

# Add title and subtitle
plt.title("Health Performance vs. Calorie Burn Rate", fontsize=14)
plt.suptitle("A Comparison Across Different Age Groups", fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(pad=2)
plt.savefig("HR_56.pdf", bbox_inches="tight")
