
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
flops_per_byte = [0.1, 10]
flops = [1e9, 1e11]

# Points
points_x = [1, 2, 3, 4, 5, 6]
points_y = [1.5e10, 3e10, 2e9, 4e10, 5e10, 7e10]
labels = [
    "Algorithm A",
    "Algorithm B",
    "Algorithm C",
    "Algorithm D",
    "Algorithm E",
    "Algorithm F",
]

markers = ["o", "s", "v", "^", "d", "<"]
axlines = [
    [[10, 20], [8e10, 8e10]],
    [[6, 20], [6e10, 6e10]],
    [[1, 20], [1e10, 1e10]],
]
x_fill = [0.1, 10, 20, 20]  # x goes from 0.1 to 20 and back to 0.1
y_fill_top = [
    1e9,
    1e11,
    1e11,
    1e11,
]  # y follows the line segment, then the horizontal line, and back to the start
y_fill_bottom = [
    0.5e9,
    0.5e9,
    0.5e9,
    0.5e9,
]  # y is constant at 0.5e9 for the bottom boundary
xlabel = "Operations/Byte"
ylabel = "Operations/Second"
title = "Performance Comparison of Algorithms"
xlim = [0.1, 2e1]
ylim = [1e9, 1e11]
textlabels = ["Memory Bandwidth", "Peak Performance", "No Optimizations", "Baseline"]
textposition = [
    [0.2, 1.5e9],
    [19, 0.85e11],
    [19, 6.5e10],
    [19, 1.2e10],
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["darkgreen", "magenta", "navy", "coral", "teal", "gold"]
# Plot the roofline model
ax.plot(flops_per_byte, flops, color="black", linewidth=1.5)
ax.plot(axlines[0][0], axlines[0][1], color="black", linestyle="--", linewidth=0.8)
ax.plot(axlines[1][0], axlines[1][1], color="black", linestyle="--", linewidth=0.8)
ax.plot(axlines[2][0], axlines[2][1], color="black", linestyle="--", linewidth=0.8)

ax.fill_between(x_fill, y_fill_top, y_fill_bottom, color="lightblue", alpha=0.5, 
linewidth=0)

# Add text annotations
for idx, text in enumerate(textlabels):
    ax.text(
        textposition[idx][0],
        textposition[idx][1],
        text,
        rotation=0,
        verticalalignment="center",
        fontsize=10,
        backgroundcolor='w'
    )

# Plot the points
for x, y, label, color, marker in zip(points_x, points_y, labels, colors, markers):
    ax.plot(x, y, label=label, color=color, marker=marker, linestyle="None", markersize=10)

# Set scale to log
ax.set_xscale("log")
ax.set_yscale("log")

# Set labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Add legend
ax.legend(fontsize=10, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_57.pdf", bbox_inches="tight")
