
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib_venn import venn2

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Prepare data for Venn Diagram
# Using business metrics: Revenue (A), Profit (B), and their overlap
set_labels = ("Revenue", "Profit")
subsets = (30, 20, 10)  # Example values

# Create a Venn diagram with above data
venn = venn2(subsets=subsets, set_labels=set_labels)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customize the colors and edge styles for better visual representation
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

venn.get_patch_by_id("10").set_color("skyblue")
venn.get_patch_by_id("10").set_edgecolor("blue")
venn.get_patch_by_id("10").set_linestyle("solid")
venn.get_patch_by_id("01").set_color("lightgreen")
venn.get_patch_by_id("01").set_edgecolor("green")
venn.get_patch_by_id("01").set_linestyle("solid")
venn.get_patch_by_id("11").set_color("lightgrey")
venn.get_patch_by_id("11").set_edgecolor("black")
venn.get_patch_by_id("11").set_linestyle("solid")

# Customize labels
for label in venn.set_labels:
    label.set_fontsize(14)
for label in venn.subset_labels:
    label.set_fontsize(12)

# Remove axis for neat visualization
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_64.pdf", bbox_inches="tight")
