
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the radar chart
labels = np.array(
    [
        "Researcher A",
        "Researcher B",
        "Researcher C",
        "Researcher D",
        "Researcher E",
        "Researcher F",
    ]
)
num_vars = len(labels)

values = np.array(
    [
        [20, 30, 25, 35, 40, 30],
        [22, 35, 30, 40, 45, 35],
        [24, 40, 35, 45, 50, 40],
        [26, 45, 40, 50, 55, 45],
        [28, 50, 45, 55, 60, 50],
    ]
)

# Compute angle for each axis
angles = [n * 2 * pi / float(num_vars) for n in range(num_vars)]
perangles = 2 * pi / (float(num_vars) * (len(values) + 1))
angles += angles[:1]
xticks = [20, 40, 60]
xtickslabel = ["20", "40", "60"]
x_angles = [n + pi / 9 for n in angles[:-1]]
# Add legend
legend_labels = ["Level 1", "Level 2", "Level 3", "Level 4", "Level 5"]
# Set the start angle to degrees
offset = 11 * pi / 18

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 8))
ax = plt.subplot(projection="polar")

# Set the direction of the plot to clockwise
ax.set_theta_direction(-1)
ax.set_theta_offset(offset)

colors = ["#A8D5BA", "#FFDDC1", "#FFC3A0", "#FF9A8B", "#FF6F91"]
for index, value in enumerate(values):
    for _index, _value in enumerate(value):
        theta1 = angles[_index] + perangles * index
        theta2 = angles[_index] + perangles * (index + 1)
        ax.bar(theta1, _value, perangles, color=colors[index], edgecolor='black')

# Add labels
ax.set_xticks(x_angles)
ax.set_xticklabels(labels, fontdict={"fontsize": 10, "fontweight": "bold", "color": "#333333"})
ax.set_yticks(xticks)
ax.set_yticklabels(xtickslabel, color="grey")
ax.tick_params(axis="x", which="major", pad=15)

# Add a grid
ax.grid(alpha=0.3)

for i in range(len(legend_labels)):
    ax.bar(
        [0, 0, 0, 0, 0], [0, 0, 0, 0, 0], color=colors[-i - 1], label=legend_labels[i]
    )
ax.legend(loc="upper right", bbox_to_anchor=(0.05, 0.2))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_66.pdf", bbox_inches="tight")
