
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Fixed seed for reproducibility

# Define the data for the radar chart
labels = np.array(
    [
        "Math",
        "Science",
        "English",
        "History",
        "Physical Education",
        "Art",
    ]
)
num_vars = len(labels)

# Simulate scores for students in different levels
values = np.array(
    [
        [75, 85, 90, 70, 80, 85],  # Level 1
        [80, 87, 92, 75, 82, 88],  # Level 2
        [83, 89, 94, 77, 85, 90],  # Level 3
        [85, 91, 96, 79, 88, 92],  # Level 4
        [88, 93, 98, 82, 90, 94],  # Level 5
    ]
)

# Compute angle for each axis
angles = [n * 2 * pi / float(num_vars) for n in range(num_vars)]
perangles = 2 * pi / (float(num_vars) * (len(values) + 1))
angles += angles[:1]
xticks = [50, 75, 100]  # Enhance readability with more ticks
xtickslabel = ["50", "75", "100"]
x_angles = [n + pi / 9 for n in angles[:-1]]
# Add legend
legend_labels = ["Level 1", "Level 2", "Level 3", "Level 4", "Level 5"]
# Set the start angle to degrees
offset = 11 * pi / 18

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 8))  # Slightly larger for better readability
ax = plt.subplot(projection="polar")

# Set the direction of the plot to clockwise
ax.set_theta_direction(-1)
ax.set_theta_offset(offset)

# Custom color palette
colors = ["#FFA07A", "#20B2AA", "#778899", "#FF6347", "#4682B4"]

for index, value in enumerate(values):
    for _index, _value in enumerate(value):
        theta1 = angles[_index] + perangles * index
        theta2 = angles[_index] + perangles * (index + 1)
        ax.bar(theta1, _value, perangles, color=colors[index], edgecolor='black', linewidth=0.5)

# Add labels for each axis
ax.set_xticks(x_angles)
ax.set_xticklabels(labels, fontdict={"fontsize": 10, "fontweight": 'bold'})
ax.set_yticks(xticks)
ax.set_yticklabels(xtickslabel, color="grey")
ax.tick_params(axis="x", which="major", pad=15)

# Add a grid
ax.grid(alpha=0.3)

# Add legend with improved positioning
for i in range(len(legend_labels)):
    ax.bar(
        [0, 0, 0, 0, 0], [0, 0, 0, 0, 0], color=colors[-i - 1], label=legend_labels[i]
    )
ax.legend(loc="upper right", bbox_to_anchor=(0.1, 0.1))

# Add Title
plt.title("Student Performance Across Subjects", fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_67.pdf", bbox_inches="tight")
