
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data and labels for the media domain
theta = [0.2, 1.8, 3.0, 4.5, 5.5]  # Angles for the bars
radii = np.array([8, 5, 9, 3, 7])  # Radii of the bars
width = [0.7, 0.6, 1.8, 1.2, 1.0]  # Width of the bars
categories = [
    "Streaming",
    "Social Media",
    "News",
    "Music",
    "Gaming",
]  # Labels for the bars

# Labels for the plot
title = "Media Consumption Patterns"
filename = "HR_16_3.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color scheme
colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99','#c2c2f0'] 

# Create the figure
plt.figure(figsize=(9, 9))
ax = plt.subplot(111, projection="polar")  # Set up polar plot

# Plot the bars
bars = ax.bar(theta, radii, width=width, bottom=0, color=colors, alpha=0.7, zorder=3)

# Add labels to the bars
for bar, angle, label in zip(bars, theta, categories):
    rotation = np.degrees(angle)  # Convert angle to degrees
    alignment = "center"  # Center align the labels
    # Place the text inside the bar, rotated correctly
    ax.text(
        angle,
        bar.get_height() + 0.5,
        label,
        ha=alignment,
        va="center",
        rotation_mode="anchor",
        fontsize=12
    )

# Add a title
plt.title(title, va='bottom', fontsize=16, fontweight='bold')

# Remove the polar angle labels to declutter the plot
ax.set_xticklabels([])

# Remove the radial labels
ax.set_yticklabels([])

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_71.pdf", bbox_inches="tight")
