
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data and labels
theta = [0, 0.8, 1.6, 2.4, 3.2, 4.0, 4.8, 5.6]  # Angles for the bars
radii = np.array([8, 5, 7, 4, 6, 9, 3, 7])  # Radii of the bars
width = [0.5, 0.6, 0.7, 0.9, 0.5, 0.8, 0.6, 0.7]  # Width of the bars
categories = [
    "General Consultation",
    "Pediatrics",
    "Cardiology",
    "Orthopedics",
    "Dermatology",
    "Neurology",
    "Psychiatry",
    "Radiology",
]  # Labels for the bars

title = "Demand for Healthcare Services"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = plt.cm.Blues(radii / 10.0)  # Colors mapped to the radii values
# Create the figure
plt.figure(figsize=(10, 8))
ax = plt.subplot(111, projection="polar")  # Set up polar plot

# Plot the bars
bars = ax.bar(theta, radii, width=width, bottom=0, color=colors, alpha=0.7, zorder=3)

# Add labels to the bars
for bar, angle, label in zip(bars, theta, categories):
    rotation = np.degrees(angle)  # Convert angle to degrees
    alignment = "center"  # Center align the labels
    # Place the text inside the bar, rotated correctly
    ax.text(
        angle,
        bar.get_height() + 0.5,
        label,
        ha=alignment,
        va="center",
        rotation_mode="anchor",
    )

# Remove the polar angle labels to declutter the plot
ax.set_xticklabels([])

# Remove the radial labels
ax.set_yticklabels([])

# Set the title
plt.title(title, size=20, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_73.pdf", bbox_inches="tight")
