
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Chart Labels and Title
supertitle = "Monthly Energy Consumption"
title = "Energy Consumption Trends Over a Year"
xlabel = "Month"
ylabel = "Energy Consumption (MWh)"
legendlabels = ["Solar", "Wind", "Fossil Fuels"]

np.random.seed(0)

# Generate data for 12 months
months = np.arange(1, 13)
solar = np.random.uniform(30, 80, size=len(months))
wind = np.random.uniform(20, 70, size=len(months))
fossil_fuels = np.random.uniform(200, 300, size=len(months))
energy_sources = [solar, wind, fossil_fuels]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color scheme
colors = ["#66c2a5", "#8da0cb", "#fc8d62"]

# Plotting the stackplot
ax.stackplot(months, energy_sources, baseline="wiggle", colors=colors, labels=legendlabels)

# Adding labels, title, and legend
fig.suptitle(supertitle, fontsize=16)
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc="upper left")

# Adding grid lines for better readability
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_75.pdf", bbox_inches="tight")
