
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# initialise labels and a numpy array make sure you have
# N labels of N number of values in the array
xlabels = ["January", "February", "March", "April", "May"]
cityA = np.array([5, 7, 10, 15, 18])
cityB = np.array([3, 5, 9, 14, 17])

# Labels and Plot Types
hat_graph_label = ["City A", "City B"]

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Average Temperature (°C)"
ylim_values = [0, 20]
title = "Average Monthly Temperatures for Two Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#76b041"]

def hat_graph(ax, xlabels, values, group_labels):
    def label_bars(heights, rects, ax):
        """Attach a text label on top of each bar."""
        for height, rect in zip(heights, rects):
            ax.annotate(
                f"{height}°C",
                xy=(rect.get_x() + rect.get_width() / 2, height),
                xytext=(0, 4),  # 4 points vertical offset.
                textcoords="offset points",
                ha="center",
                va="bottom",
            )

    values = np.asarray(values)
    x = np.arange(values.shape[1])
    ax.set_xticks(x, labels=xlabels)
    spacing = 0.3  # spacing between hat groups
    width = (1 - spacing) / values.shape[0]
    heights0 = values[0]
    for i, (heights, group_label, color) in enumerate(zip(values, group_labels, colors)):
        rects = ax.bar(
            x - spacing / 2 + i * width,
            heights - heights0,
            width,
            bottom=heights0,
            label=group_label,
            edgecolor='black',
            color=color,
            hatch="///" if i == 1 else None,
        )
        label_bars(heights, rects, ax)


fig, ax = plt.subplots(figsize=(9, 6))
hat_graph(ax, xlabels, [cityA, cityB], hat_graph_label)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_ylim(ylim_values)
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("HR_82.pdf", bbox_inches="tight")
