
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data formatted as (start_time, duration)
broken_barh_datax1 = [(1950, 30), (1985, 10), (2000, 20)]
broken_barh_datay1 = (10, 9)
broken_barh_datax2 = [(1960, 10), (1990, 15)]
broken_barh_datay2 = (20, 9)
broken_barh_datax3 = [(1955, 15), (1975, 10)]
broken_barh_datay3 = (30, 9)
broken_barh_datax4 = [(1965, 10), (1980, 20), (2005, 10)]
broken_barh_datay4 = (40, 9)

# Labels and text for chart
labels = ["Growth Period", "Decline", "Stagnation", "Recovery and Growth"]
datalabels = ["Country A", "Country B", "Country C", "Country D"]
yticks = [15, 25, 35, 45]
ylim = [5, 55]
xlim = [1945, 2025]
xlabel = "Years"
annotations = "Economic boom leading to rapid growth"
annotatestart = (1985, 25)
annotateend = (0.75, 0.7)
title = "Population Growth Analysis Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
facecolors = ["#82b74b", "#d9534f", "#f0ad4e", "#5bc0de"]

# Horizontal bar plot with gaps to show different population phases
fig, ax = plt.subplots(figsize=(10, 6))
ax.broken_barh(
    broken_barh_datax1, broken_barh_datay1, facecolors=facecolors[0], label=labels[0]
)
ax.broken_barh(
    broken_barh_datax2, broken_barh_datay2, facecolors=facecolors[1], label=labels[1]
)
ax.broken_barh(
    broken_barh_datax3, broken_barh_datay3, facecolors=facecolors[2], label=labels[2]
)
ax.broken_barh(
    broken_barh_datax4,
    broken_barh_datay4,
    facecolors=facecolors,
    label=labels[3],
)

ax.set_ylim(ylim)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_yticks(yticks, labels=datalabels)  # More descriptive labels
ax.grid(True, linestyle='--', linewidth=0.5)  # Make grid lines visible with a dashed line
ax.annotate(
    annotations,
    annotatestart,
    xytext=annotateend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=12,
    horizontalalignment="right",
    verticalalignment="top",
)

# Title and legend
ax.set_title(title, fontsize=14, fontweight='bold')
ax.legend(loc="lower right", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_86.pdf", bbox_inches="tight")
