
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
broken_barh_datax1 = [(6, 2), (10, 4), (15, 2)]
broken_barh_datay1 = (10, 9)
broken_barh_datax2 = [(8, 3), (20, 5)]
broken_barh_datay2 = (20, 9)
broken_barh_datax3 = [(5, 3), (14, 6), (22, 2)]
broken_barh_datay3 = (30, 9)
broken_barh_datax4 = [(0, 5), (12, 8), (21, 3)]
broken_barh_datay4 = (40, 9)
labels = ["Sleeping", "Working", "Studying", "Leisure"]
datalabels = ["Group 1", "Group 2", "Group 3", "Group 4"]
yticks = [15, 25, 35, 45]
ylim = [5, 50]
xlim = [0, 30]
xlabel = "Hours of the Day"
annotations = "Peak activity varies with group"
annotatestart = (12, 35)
annotateend = (0.8, 0.9)
title = "Daily Activity Patterns Across Different Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
facecolors = ["#7F3C8D", "#11A579", "#3969AC", "#F2B701"]
fig, ax = plt.subplots(figsize=(10, 6))
ax.broken_barh(
    broken_barh_datax1, broken_barh_datay1, facecolors=facecolors[0], label=labels[0]
)
ax.broken_barh(
    broken_barh_datax2, broken_barh_datay2, facecolors=facecolors[1], label=labels[1]
)
ax.broken_barh(
    broken_barh_datax3, broken_barh_datay3, facecolors=facecolors[2], label=labels[2]
)
ax.broken_barh(
    broken_barh_datax4,
    broken_barh_datay4,
    facecolors=facecolors[3],
    label=labels[3],
)

ax.set_ylim(ylim)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_yticks(yticks, labels=datalabels)
ax.grid(True)  # Enable grid
ax.annotate(
    annotations,
    annotatestart,
    xytext=annotateend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=12,
    horizontalalignment="right",
    verticalalignment="top",
)

# Add chart title and legend
ax.set_title(title)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_88.pdf", bbox_inches="tight")
