
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.tri as tri

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Set a different seed for variation

# First create the x and y coordinates of the points.
n_angles = 48
n_radii = 16
min_radius = 0.3
max_radius = 1.0
radii = np.linspace(min_radius, max_radius, n_radii)

angles = np.linspace(0, 2 * np.pi, n_angles, endpoint=False)
angles = np.repeat(angles[..., np.newaxis], n_radii, axis=1)
angles[:, 1::2] += np.pi / n_angles

x = (radii * np.cos(angles)).flatten()
y = (radii * np.sin(angles)).flatten()
z = (np.sin(radii) * np.cos(5 * angles) + radii).flatten()  # Modified for social engagement pattern

# Labels and title
title = "Social Network Engagement across Regions"
xlabel = 'X-Axis Label'
ylabel = 'Y-Axis Label'
legend_title = 'Engagement Level'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the Triangulation; no triangles so Delaunay triangulation created.
triang = tri.Triangulation(x, y)

# Mask off unwanted triangles.
triang.set_mask(
    np.hypot(x[triang.triangles].mean(axis=1), y[triang.triangles].mean(axis=1))
    < min_radius
)
fig1, ax1 = plt.subplots(figsize=(10, 8))
ax1.set_aspect("equal")
tpc = ax1.tripcolor(triang, z, shading="flat", cmap="spring")  # Changed colormap to 'spring'
fig1.colorbar(tpc, ax=ax1, label=legend_title)  # Added colorbar label
ax1.set_title(title, fontsize=16, fontweight='bold')  # Title with larger font and bold
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.grid(True, linestyle='--', linewidth=0.5, color='gray')  # Add grid for better readability

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_97.pdf", bbox_inches="tight")
