
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.image import NonUniformImage

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Linear x and y arrays for cell centers:
x = np.linspace(-4, 4, 9)
y = np.linspace(-4, 4, 9)
# Highly nonlinear x array:
x2 = x**3

# Define a mathematical function z = sin(sqrt(x^2 + y^2)):
z = np.sin(np.sqrt(x[np.newaxis, :] ** 2 + y[:, np.newaxis] ** 2))

# Text labels and other parameters
suptitle = "Visualization of sin(sqrt(x^2 + y^2)) using NonUniformImage"
xlabels = ["Linear X", "Nonlinear X"]
ylabels = "Y axis"
interpolations = ["nearest", "bilinear"]
xlim = [[-4, 4], [-64, 64], [-4, 4], [-64, 64]]
ylim = [[-4, 4], [-4, 4], [-4, 4], [-4, 4]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
cmap = cm.viridis

fig, axs = plt.subplots(nrows=2, ncols=2, layout="constrained", figsize=(10, 8))
fig.suptitle(suptitle, fontsize="large")

# Plot for Nearest Interpolation with Linear X
ax = axs[0, 0]
im = NonUniformImage(
    ax,
    interpolation=interpolations[0],
    extent=(xlim[0][0], xlim[0][1], ylim[0][0], ylim[1][0]),
    cmap=cmap,
)
im.set_data(x, y, z)
ax.add_image(im)
ax.set_xlim(xlim[0])
ax.set_ylim(ylim[0])
ax.set_title(f"{interpolations[0]} - {xlabels[0]}")
ax.set_xlabel(xlabels[0])
ax.set_ylabel(ylabels)

# Plot for Nearest Interpolation with Nonlinear X
ax = axs[0, 1]
im = NonUniformImage(
    ax,
    interpolation=interpolations[0],
    extent=(xlim[1][0], xlim[1][1], ylim[0][0], ylim[1][0]),
    cmap=cmap,
)
im.set_data(x2, y, z)
ax.add_image(im)
ax.set_xlim(xlim[1])
ax.set_ylim(ylim[1])
ax.set_title(f"{interpolations[0]} - {xlabels[1]}")
ax.set_xlabel(xlabels[1])
ax.set_ylabel(ylabels)

# Plot for Bilinear Interpolation with Linear X
ax = axs[1, 0]
im = NonUniformImage(
    ax,
    interpolation=interpolations[1],
    extent=(xlim[2][0], xlim[2][1], ylim[2][0], ylim[2][1]),
    cmap=cmap,
)
im.set_data(x, y, z)
ax.add_image(im)
ax.set_xlim(xlim[2])
ax.set_ylim(ylim[2])
ax.set_title(f"{interpolations[1]} - {xlabels[0]}")
ax.set_xlabel(xlabels[0])
ax.set_ylabel(ylabels)

# Plot for Bilinear Interpolation with Nonlinear X
ax = axs[1, 1]
im = NonUniformImage(
    ax,
    interpolation=interpolations[1],
    extent=(xlim[3][0], xlim[3][1], ylim[3][0], ylim[3][1]),
    cmap=cmap,
)
im.set_data(x2, y, z)
ax.add_image(im)
ax.set_xlim(xlim[3])
ax.set_ylim(ylim[3])
ax.set_title(f"{interpolations[1]} - {xlabels[1]}")
ax.set_xlabel(xlabels[1])
ax.set_ylabel(ylabels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_98.pdf", bbox_inches="tight")
