
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.image import NonUniformImage

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
interp = "nearest"

# Linear x and y arrays representing geographical coordinates:
x = np.linspace(-4, 4, 100)
y = np.linspace(-4, 4, 100)

# Simulated topographical data using sine and cosine functions:
X, Y = np.meshgrid(x, y)
Z = np.sin(X**2 + Y**2) * np.cos(X) * np.sin(Y)

# Text labels
suptitle = "Topographical Map Visualization"
xlim = [[-4, 4], [-4, 4], [-4, 4], [-4, 4]]
ylim = [[-4, 4], [-4, 4], [-4, 4], [-4, 4]]
xlabel = "Longitude"
ylabel = "Latitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(nrows=2, ncols=2, layout="constrained", figsize=(10, 8))
fig.suptitle(suptitle, fontsize="x-large")
for i, ax in enumerate(axs.flat):
    if i < 2:
        interp = "nearest"
    else:
        interp = "bilinear"
    
    im = NonUniformImage(
        ax,
        interpolation=interp,
        extent=(xlim[i][0], xlim[i][1], ylim[i][0], ylim[i][1]),
        cmap=cm.terrain,
    )
    im.set_data(x, y, Z)
    ax.add_image(im)
    ax.set_xlim(xlim[i])
    ax.set_ylim(ylim[i])
    ax.set_title(f"Interpolation: {interp}")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_99.pdf", bbox_inches="tight")
