
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new dummy data for the education domain
public_school_scores = [
    150,
    240,
    320,
    480,
    540,
    600,
    750,
    820,
    950,
    1750,
    8800,
]  # Public School
private_school_scores = [
    120,
    210,
    310,
    370,
    510,
    760,
    950,
    1800,
    2600,
    3300,
    6800,
]  # Private School
bins = [0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9]
labels = ["Public School", "Private School"]
xlabel = "Score Range Proportion"
xlim = [-0.1, 1.1]
ylim = [0, 20000]
ylabel = "Number of Students"
xticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
yticks = [0, 2500, 5000, 7500, 10000, 12500, 15000, 17500, 20000]
left, bottom, width, height = [0.3, 0.3, 0.3, 0.4]
insetxlim = [0.35, 0.7]
insetxticks = [0.35, 0.40, 0.45, 0.50, 0.55, 0.60, 0.65, 0.70]
insetylim = [0, 1500]
insetyticks = [0, 250, 500, 750, 1000, 1250, 1500]
mainpointleft = [0.39, 0.74]
mainpointright = [0.74, 820]
insetleft = [0.35, 0]
insetright = [0.7, 0]

# Text labels
suptitle = "Comparison of Student Scores in Public and Private Schools"
title = "Score Distribution by Type of School"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.045  # Slightly less than the bin width to create a gap

ax_main.bar(
    bins,
    public_school_scores,
    width=bar_width,
    color="orange",
    align="center",
    label=labels[0],
    edgecolor="white",
    alpha=0.8
)
ax_main.bar(
    bins,
    private_school_scores,
    width=bar_width,
    color="steelblue",
    align="center",
    bottom=public_school_scores,
    label=labels[1],
    edgecolor="white",
    alpha=0.8
)
ax_main.set_xlabel(xlabel)
ax_main.set_xlim(xlim)
ax_main.set_xticks(xticks)
ax_main.set_ylabel(ylabel)
ax_main.set_ylim(ylim)
ax_main.set_yticks(yticks)
ax_main.legend(loc="upper right", prop={"size": 14})
ax_main.grid(True)

# Create inset plot with adjusted bar widths and white borders

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    bins[:6],
    public_school_scores[:6],
    width=bar_width,
    color="orange",
    align="center",
    edgecolor="white",
    alpha=0.8
)
ax_inset.bar(
    bins[:6],
    private_school_scores[:6],
    width=bar_width,
    color="steelblue",
    align="center",
    bottom=public_school_scores[:6],
    edgecolor="white",
    alpha=0.8
)
ax_inset.set_xlim(insetxlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(insetxticks)  # Zoom in on the right part of the data
ax_inset.set_ylim(insetylim)
ax_inset.set_yticks(insetyticks)
ax_inset.grid(True)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainpointleft)
main_plot_right = ax_main.transData.transform_point(mainpointright)

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(insetleft)
inset_right = ax_inset.transData.transform_point(insetright)

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(suptitle, fontsize=16)
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("PIP_26.pdf", bbox_inches="tight")
