
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
x = ["January", "February", "March", "April"]
y1 = [5, 7, 12, 18]
y2 = [6, 8, 14, 20]
y3 = [2, 5, 10, 15]
y4 = [-1, 3, 8, 12]
labels = ["City A", "City B", "City C", "City D"]
insertax1 = [0.2, 0.6, 0.2, 0.2]
insertylim1 = [-2, 8]
insertxlim1 = [0.5, 1.5]
insertax2 = [0.7, 0.2, 0.2, 0.2]
insertylim2 = [10, 20]
insertxlim2 = [2.5, 3.5]
xlabel = "Month"
ylabel = "Temperature (°C)"
title = "Monthly Temperature Trends by City"
insetaxes = [0.2, 0.6, 0.2, 0.2]
arrowend1 = [0.25, 0.75]
arrowend2 = [0.75, 0.25]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size to match original image's dimensions

ax.plot(x, y1, "o--", color="#1f77b4", label=labels[0])  # Blue: City A
ax.plot(x, y2, "s-.", color="#ff7f0e", label=labels[1])  # Orange: City B
ax.plot(x, y3, "d-", color="#2ca02c", label=labels[2])  # Green: City C
ax.plot(x, y4, "v:", color="#d62728", label=labels[3])  # Red: City D

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insertax1)
ax_inset1.plot(x, y1, "o--", color="#1f77b4")
ax_inset1.plot(x, y2, "s-.", color="#ff7f0e")
ax_inset1.plot(x, y3, "d-", color="#2ca02c")
ax_inset1.plot(x, y4, "v:", color="#d62728")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the second inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(x, y1, "o--", color="#1f77b4")
ax_inset2.plot(x, y2, "s-.", color="#ff7f0e")
ax_inset2.plot(x, y3, "d-", color="#2ca02c")
ax_inset2.plot(x, y4, "v:", color="#d62728")
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)

# Annotate with arrows
ax.annotate(
    "",
    xy=(x[1], y4[1]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)
ax.annotate(
    "",
    xy=(x[3], y4[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_29.pdf", bbox_inches="tight")
