
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate some dummy data for "Book Review Ratings" domain
category1 = [
    1500, 2300, 2700, 3200, 2800, 2500, 2200, 1900, 1600, 1300, 1100
]  # Ratings for Known Authors
category2 = [
    800,  1100, 1400, 1600, 1500, 1400, 1100,  900,  700,  600,  400
]  # Ratings for New Authors
bins = [0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0]
labels = ["Known Authors", "New Authors"]
xmainlabel = "Rating Interval"
xmainlim = [-0.1, 5.5]
xmainticks = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0]
ymainlabel = "Number of Reviews"
ymainlim = [0, 6000]
ymainticks = [0, 1000, 2000, 3000, 4000, 5000, 6000]

xinsetlim = [2.25, 3.25]
xinsetticks = [ 2.5, 3.0]
yinsetlim = [0, 6000]
yinsetticks = [0, 2000, 4000, 6000]

left, bottom, width, height = [0.5, 0.6, 0.3, 0.3]
mainplotline = [(1.75, 1000), (3.5, 1000)]
maininsetline = [(2.25, 0), (3.25, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.45  # Adjust bar width for better visual separation
ax_main.bar(
    bins,
    category1,
    width=bar_width,
    color="#81C784",  # Greenish color
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    bins,
    category2,
    width=bar_width,
    color="#FFB74D",  # Orange color
    align="center",
    bottom=category1,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 12})
ax_main.grid()

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    bins[4:],  # Only include bins from 2.0 onwards
    category1[4:],
    width=bar_width,
    color="#81C784",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    bins[4:],  # Only include bins from 2.0 onwards
    category2[4:],
    width=bar_width,
    color="#FFB74D",
    align="center",
    bottom=category1[4:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on higher ratings
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)
ax_inset.grid()

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_31.pdf", bbox_inches="tight")
