
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated Data for Media Audience Engagement
x = 2 ** np.arange(6, 12)
platform_a = np.array([50000, 75000, 100000, 125000, 150000, 175000])
platform_b = np.array([80000, 120000, 160000, 200000, 240000, 280000])
platform_c = np.array([30000, 50000, 70000, 90000, 110000, 130000])
platform_d = np.array([45000, 65000, 85000, 105000, 125000, 145000])

labels = ["Platform A", "Platform B", "Platform C", "Platform D"]
xlabel = "Growth Phase"
ylabel = "Audience Engagement Metrics"
xilm = [-10000, 300000]
ylim = [-10000, 300000]
yticks = [0, 50000, 100000, 150000, 200000, 250000]
insetaxes = [0.7, 0.2, 0.25, 0.25]
yinsetlim = [0, 140000]
xtickslabels = [f"P {i}" for i in range(1, 7)]
xinsetxtickslabels = ["P 4", "P 5", "P 6"]
yinsetyticks = [40000, 80000, 120000]
title = "Audience Engagement on Different Platforms"
legendlabels = ["Platform A", "Platform B", "Platform C", "Platform D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data
ax.plot(x, platform_a, "o-", label=labels[0], color="#FF6F61")  # Warm orange
ax.plot(x, platform_b, "x-", label=labels[1], color="#6B5B95")  # Deep purple
ax.plot(x, platform_c, "s-", label=labels[2], color="#88B04B")  # Olive green
ax.plot(x, platform_d, "d-", label=labels[3], color="#2A9D8F")  # Teal

# Set the x-axis to be logarithmic
ax.set_xscale("log")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a legend
ax.legend(title='Platforms', loc='upper left')

# Create an inset axis for more detailed data
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(x, platform_c, "s-", color="#88B04B")  # Olive green
ax_inset.plot(x, platform_d, "d-", color="#2A9D8F")  # Teal
ax_inset.set_xscale("log")

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim(ax.get_xlim())
ax_inset.set_yticks(yinsetyticks)

# Change x-axis tick labels to custom phases notation
ax.set_xticks(x)
ax.set_xticklabels(xtickslabels)
ax_inset.set_xticks(x[2:5])
ax_inset.set_xticklabels(xinsetxtickslabels)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_33.pdf", bbox_inches="tight")
