
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
years = np.arange(2016, 2022)
visitors = np.array([3.2, 3.5, 2.8, 4.0, 5.3, 5.6]) * 1e6
revenue = np.array([5, 6, 6.5, 7, 7.5, 8]) * 1e9   # in dollars
satisfaction = np.array([70, 75, 80, 85, 90, 95])  # in percentage

labels = ["Visitors", "Revenue", "Satisfaction"]
xlabel = "Year"
ylabel = "Value"
ylim = [0, 9e9]
yticks = [0, 2e9, 4e9, 6e9, 8e9]
insetaxes = [0.6, 0.2, 0.35, 0.3]
yinsetlim = [60, 100]
xtickslabels = [str(year) for year in years]
yinsetyticks = [70, 80, 90, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data
ax.plot(years, visitors, "o-", label=labels[0], color="#2ca02c", linewidth=2, markersize=8)
ax.plot(years, revenue, "s--", label=labels[1], color="#1f77b4", linewidth=2, markersize=8)
ax.plot(years, satisfaction, "D-.", label=labels[2], color="#ff7f0e", linewidth=2, markersize=8)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Adjust y-axis limits
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.set_yticklabels(['0', '2B', '4B', '6B', '8B'], fontsize=12)

# Add a legend
ax.legend(labels, loc='upper left', fontsize=12)

# Create an inset axis for the Satisfaction data
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(years, satisfaction, "D-.", color="#ff7f0e", linewidth=2, markersize=8)

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetyticks)
ax_inset.set_yticklabels(yinsetyticks, fontsize=10)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim(ax.get_xlim())
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(xtickslabels, fontsize=10)
ax_inset.set_xlabel('Year', fontsize=10)
ax_inset.set_ylabel('Satisfaction', fontsize=10)

# Change x-axis tick labels
ax.set_xticks(years)
ax.set_xticklabels(xtickslabels, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_34.pdf", bbox_inches="tight")

