
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
years = np.arange(2015, 2021, 1)
gdp_growth_countryA = np.array([2.5, 3.0, 2.8, 2.6, 2.9, 3.1])
gdp_growth_countryB = np.array([1.8, 2.0, 1.9, 2.1, 2.3, 2.5])
inflation_countryA = np.array([1.2, 1.5, 1.8, 2.0, 1.7, 1.6])
inflation_countryB = np.array([1.0, 1.3, 1.4, 1.6, 1.5, 1.7])

labels = ["GDP Growth | Country A", "GDP Growth | Country B", "Inflation | Country A", "Inflation | Country B"]
xlabel = "Year"
ylabel = "Percentage (%)"
ylim = [0, 4]
yticks = [0, 1, 2, 3, 4]
insetaxes = [0.55, 0.15, 0.3, 0.25]
yinsetlim = [0, 2]
xtickslabels = [str(year) for year in years]
yinsetyticks = [0.5, 1.0, 1.5, 2.0]
title="Economic Indicators Over Time"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted to match the original image's dimensions

# Plot the data
ax.plot(years, gdp_growth_countryA, "o-", label=labels[0], color="#1f77b4", linewidth=2, markersize=6)
ax.plot(years, gdp_growth_countryB, "s--", label=labels[1], color="#ff7f0e", linewidth=2, markersize=6)
ax.plot(years, inflation_countryA, "^:", label=labels[2], color="#2ca02c", linewidth=2, markersize=6)
ax.plot(years, inflation_countryB, "d-.", label=labels[3], color="#d62728", linewidth=2, markersize=6)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a legend
ax.legend()

# Create an inset axis for the inflation data
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(years, inflation_countryA, "^:", color="#2ca02c", linewidth=2, markersize=6)
ax_inset.plot(years, inflation_countryB, "d-.", color="#d62728", linewidth=2, markersize=6)

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim(ax.get_xlim())
ax_inset.set_yticks(yinsetyticks)

# Change x-axis tick labels to year notation
ax.set_xticks(years)
ax.set_xticklabels(xtickslabels)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(xtickslabels)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_35.pdf", bbox_inches="tight")
