
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data: Simulated monthly temperature variations for four cities
months = np.linspace(1, 12, 100)
temp_city1 = 15 + 10 * np.sin(2 * np.pi * (months - 3) / 12)
temp_city2 = 18 + 8 * np.sin(2 * np.pi * (months - 4) / 12)
temp_city3 = 20 + 5 * np.sin(2 * np.pi * (months - 5) / 12)
temp_city4 = 12 + 12 * np.sin(2 * np.pi * (months - 2) / 12)

# Labels and Plot Types
label_city1 = "City A"
label_city2 = "City B"
label_city3 = "City C"
label_city4 = "City D"

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Temperature (°C)"
zoomed_in_axes = [0.4, 0.2, 0.3, 0.3]
xlim_values = [10, 12]
ylim_values = [10, 30]
xticks_values = [10, 11, 12]
yticks_values = [15, 20, 25, 30]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the curves with custom colors and styles
ax.plot(months, temp_city1, label=label_city1, color="#1f77b4", linestyle='-', marker='o')
ax.plot(months, temp_city2, label=label_city2, color="#ff7f0e", linestyle='--', marker='s')
ax.plot(months, temp_city3, label=label_city3, color="#2ca02c", linestyle='-.', marker='^')
ax.plot(months, temp_city4, label=label_city4, color="#d62728", linestyle=':', marker='d')

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(months, temp_city1, color="#1f77b4", linestyle='-', marker='o')
ax_inset.plot(months, temp_city2, color="#ff7f0e", linestyle='--', marker='s')
ax_inset.plot(months, temp_city3, color="#2ca02c", linestyle='-.', marker='^')
ax_inset.plot(months, temp_city4, color="#d62728", linestyle=':', marker='d')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_37.pdf", bbox_inches="tight")
