
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic stock price data over 10,000 time steps
x = np.linspace(0, 10000, 100)
y1 = 150 + 50 * np.sin(x / 1000)  # Stock A
y2 = 200 + 40 * np.cos(x / 1000)  # Stock B
y3 = 180 + 45 * np.sin(x / 1200)  # Stock C
y4 = 220 + 35 * np.cos(x / 1200)  # Stock D

# Labels and Plot Types
label_StockA = "Stock A"
label_StockB = "Stock B"
label_StockC = "Stock C"
label_StockD = "Stock D"

# Axes Limits and Labels
xlabel_value = "Time Steps"
ylabel_value = "Stock Price"
zoomed_in_axes = [0.5, 0.5, 0.2, 0.2]
xlim_values = [9600, 10000]
ylim_values = [170, 230]
xticks_values = [9600, 9800, 10000]
yticks_values = [180, 200, 220]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot the curves with custom styles
ax.plot(x, y1, color=colors[0], linestyle='-', linewidth=2, label=label_StockA)
ax.plot(x, y2, color=colors[1], linestyle='--', linewidth=2, label=label_StockB)
ax.plot(x, y3, color=colors[2], linestyle='-.', linewidth=2, label=label_StockC)
ax.plot(x, y4, color=colors[3], linestyle=':', linewidth=2, label=label_StockD)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(x, y1, color=colors[0], linestyle='-')
ax_inset.plot(x, y2, color=colors[1], linestyle='--')
ax_inset.plot(x, y3, color=colors[2], linestyle='-.')
ax_inset.plot(x, y4, color=colors[3], linestyle=':')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_38.pdf", bbox_inches="tight")
