
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for transportation domain
x = np.linspace(0, 200, 200)
y1 = 70 + 5 * np.sin(0.1 * x) + np.random.normal(0, 2, 200)  # Electrical vehicles speed over time
y2 = 60 + 4 * np.sin(0.1 * x) + np.random.normal(0, 2, 200)  # Gasoline vehicles speed over time
labels = ["Electrical Vehicles", "Gasoline Vehicles"]
xlabel = "Time (months)"
ylabel = "Average Speed (km/h)"
title = "Average Speed of Vehicles Over Time"
insetxlim = [80, 100]
insetylim = [50, 80]
insetxticks = [80, 90, 100]
insetyticks = [50, 60, 70, 80]
insetaxes = [0.65, 0.65, 0.25, 0.25]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Slightly larger figure size for better readability

# Plot the curves
ax.plot(x, y1, color="#1f77b4", linestyle='-', linewidth=2, marker='o', label=labels[0])
ax.plot(x, y2, color="#ff7f0e", linestyle='--', linewidth=2, marker='x', label=labels[1])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim([40, 100])

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(
    insetaxes
)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(x, y1, color="#1f77b4", linestyle='-', linewidth=1)
ax_inset.plot(x, y2, color="#ff7f0e", linestyle='--', linewidth=1)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_39.pdf", bbox_inches="tight")
