
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Set seed for reproducibility

# Sample data for health domain: impact of two treatments over time
x = np.linspace(0, 200, 200)
y1 = np.linspace(0.5, 0.8, 200) * (1 + np.random.normal(0, 0.05, 200))  # Treatment A
y2 = np.linspace(0.4, 0.6, 200) * (1 + np.random.normal(0, 0.05, 200))  # Treatment B

# Labels and other textual content
labels = ["Treatment A", "Treatment B"]
xlabel = "Days"
ylabel = "Health Improvement Score"
title = "Comparison of Two Treatments Over Time"
legendlabels = ["Treatment A", "Treatment B"]
insetxlim = [80, 100]
insetylim = [0.50, 0.85]
insetxticks = [80, 90, 100]
insetyticks = [0.50, 0.60, 0.70, 0.80, 0.85]
insetaxes = [0.15, 0.6, 0.25, 0.25]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the curves with enhanced styles
ax.plot(x, y1, color="#1f77b4", linestyle='-', linewidth=2, marker='o', label=labels[0])
ax.plot(x, y2, color="#2ca02c", linestyle='--', linewidth=2, marker='s', label=labels[1])

# Set labels, title, and grid
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.grid(True, linestyle='--', alpha=0.6)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(x, y1, color="#1f77b4", linestyle='-', linewidth=1)
ax_inset.plot(x, y2, color="#2ca02c", linestyle='--', linewidth=1)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_40.pdf", bbox_inches="tight")
