
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # optimized location

np.random.seed(0)

# Sample data to approximate temperature trends over 200 days
days = np.linspace(1, 200, 200)
city1_temps = np.linspace(15, 25, 200) + np.random.normal(0, 1.5, 200)
city2_temps = np.linspace(10, 20, 200) + np.random.normal(0, 1.5, 200)

# Labels and titles
labels = ["City 1", "City 2"]
xlabel = "Days"
ylabel = "Temperature (°C)"
title = "Daily Temperature Trends"
insetxlim = [80, 90]
insetylim = [12, 22]
insetxticks = [80, 85, 90]
insetyticks = [12, 15, 18, 21]
insetaxes = [0.65, 0.2, 0.25, 0.25]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(6, 4))

# Plot the curves
ax.plot(days, city1_temps, "#1f77b4", linestyle='-', linewidth=1.5, marker='o', markersize=4, label=labels[0])
ax.plot(days, city2_temps, "#2ca02c", linestyle='--', linewidth=1.5, marker='s', markersize=4, label=labels[1])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim([0, 200])
ax.set_ylim([0, 30])

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(
    insetaxes
)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(days, city1_temps, "#1f77b4", linestyle='-', linewidth=1.5, marker='o', markersize=4)
ax_inset.plot(days, city2_temps, "#2ca02c", linestyle='--', linewidth=1.5, marker='s', markersize=4)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_41.pdf", bbox_inches="tight")
