
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate sample data for the genre clusters with adjusted positions and spread
x_classics = np.random.normal(-2, 1, 100)
y_classics = np.random.normal(2, 1, 100)

x_sci_fi = np.random.normal(2, 1.5, 100)
y_sci_fi = np.random.normal(-2, 1.5, 100)

x_self_help = np.random.normal(0, 1.2, 100)
y_self_help = np.random.normal(0, 1.2, 100)

# Labels and axis settings for the plot
xlabel = "Borrow Frequency"
ylabel = "Return Rate"
title = "Library Books Checkout Analysis"
supertitle = "Book Genres"
legendlabels = ["Classics", "Science Fiction", "Self-Help"]
insetxlim = [-1, 1]
insetylim = [-1, 1]
insetxticks = [-1.0, 0, 1.0]
insetyticks = [-1.0, 0, 1.0]
axesgrid = [0.65, 0.1, 0.2, 0.2]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the requirements
fig, ax = plt.subplots(figsize=(10, 8))

# Plot the data with modified colors and markers
ax.scatter(x_classics, y_classics, c="#8B4513", label=legendlabels[0], marker='o')  # Sienna for Classics
ax.scatter(x_sci_fi, y_sci_fi, c="#1E90FF", label=legendlabels[1], marker='^')       # DodgerBlue for Science Fiction
ax.scatter(x_self_help, y_self_help, c="#32CD32", label=legendlabels[2], marker='s') # LimeGreen for Self-Help

# Add title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
fig.suptitle(supertitle, fontsize=16)

# Add the legend
ax.legend(legendlabels, loc="upper right", frameon=True)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(x_classics, y_classics, c="#8B4513", marker='o')
ax_inset.scatter(x_sci_fi, y_sci_fi, c="#1E90FF", marker='^')
ax_inset.scatter(x_self_help, y_self_help, c="#32CD32", marker='s')
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")


# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_42.pdf", bbox_inches="tight")
