
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate sample data for three different income groups and their expenditures
low_income_housing = np.random.normal(500, 100, 100)
low_income_food = np.random.normal(300, 50, 100)
low_income_education = np.random.normal(100, 20, 100)

middle_income_housing = np.random.normal(1000, 200, 100)
middle_income_food = np.random.normal(600, 100, 100)
middle_income_education = np.random.normal(300, 50, 100)

high_income_housing = np.random.normal(2000, 300, 100)
high_income_food = np.random.normal(1000, 150, 100)
high_income_education = np.random.normal(500, 100, 100)

# Labels and plot settings
labels = ["Low Income", "Middle Income", "High Income"]
xlabel = "Expenditure on Housing"
ylabel = "Expenditure on Food"
title = "Income Groups vs Expenditures"
insetxlim = [900, 1100]
insetylim = [550, 650]
insetxticks = [900, 1000, 1100]
insetyticks = [550, 600, 650]
axesgrid = [0.65, 0.1, 0.2, 0.2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 8))

# Plot the data with customized colors and markers
ax.scatter(low_income_housing, low_income_food, c="#FF5733", marker='o', label=labels[0])
ax.scatter(middle_income_housing, middle_income_food, c="#33FF57", marker='s', label=labels[1])
ax.scatter(high_income_housing, high_income_food, c="#3357FF", marker='^', label=labels[2])

# Adding axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add the legend
ax.legend(loc="upper left", frameon=True)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(low_income_housing, low_income_food, c="#FF5733", marker='o', label=labels[0])
ax_inset.scatter(middle_income_housing, middle_income_food, c="#33FF57", marker='s', label=labels[1])
ax_inset.scatter(high_income_housing, high_income_food, c="#3357FF", marker='^', label=labels[2])
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("PIP_43.pdf", bbox_inches="tight")
