
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new sample data for three artistic styles clusters
x1 = np.random.normal(3, 1.5, 120)
y1 = np.random.normal(5, 1.5, 120)

x2 = np.random.normal(6, 1.5, 120)
y2 = np.random.normal(1, 1.5, 120)

x3 = np.random.normal(2, 1.5, 120)
y3 = np.random.normal(8, 1.5, 120)

# Text labels and chart parameters
xlabel = "X-axis: Artistic Dimension 1"
ylabel = "Y-axis: Artistic Dimension 2"
title = "Distribution of Art Styles"
insetxlim = [1, 4]
insetylim = [4, 7]
insetxticks = [1.0, 2.5, 4.0]
insetyticks = [4.0, 5.5, 7.0]
axesgrid = [0.35, 0.1, 0.2, 0.2]
legend_labels = ["Modern", "Traditional", "Abstract"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size and style
fig, ax = plt.subplots(figsize=(8, 8))

# Plot the data with customized colors and markers
ax.scatter(x1, y1, c="#D32F2F", label=legend_labels[0], marker='o', edgecolor='k')
ax.scatter(x2, y2, c="#1976D2", label=legend_labels[1], marker='s', edgecolor='k')
ax.scatter(x3, y3, c="#388E3C", label=legend_labels[2], marker='^', edgecolor='k')

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add the legend with a customized position and frame
ax.legend(loc="upper left", frameon=True)

# Create the inset with zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(x1, y1, c="#D32F2F", label=legend_labels[0], marker='o', edgecolor='k')
ax_inset.scatter(x2, y2, c="#1976D2", label=legend_labels[1], marker='s', edgecolor='k')
ax_inset.scatter(x3, y3, c="#388E3C", label=legend_labels[2], marker='^', edgecolor='k')
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("PIP_44.pdf", bbox_inches="tight")
