
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

clusters = {
    "Christianity": np.random.normal(loc=(0, 2), scale=1, size=(50, 2)),
    "Islam": np.random.normal(loc=(5, 5), scale=1, size=(30, 2)),
    "Hinduism": np.random.normal(loc=(-3, 0), scale=1, size=(40, 2)),
    "Buddhism": np.random.normal(loc=(5, -5), scale=1, size=(60, 2)),
    "Judaism": np.random.normal(loc=(-5, -5), scale=1, size=(70, 2)),
    "Other": np.random.normal(loc=(5, 10), scale=1, size=(45, 2)),
}

# Colors for each cluster using a new color scheme
colors = {
    "Christianity": "#1f77b4",     # muted blue
    "Islam": "#ff7f0e",            # safety orange
    "Hinduism": "#2ca02c",         # cooked asparagus green
    "Buddhism": "#d62728",         # brick red
    "Judaism": "#9467bd",          # muted purple
    "Other": "#8c564b",            # chestnut brown
}

# Labels and text properties
xlabel = "Dimension 1"
ylabel = "Dimension 2"
title = "Religious Demographics Distribution"
legendlabels = {"Christianity", "Islam", "Hinduism", "Buddhism", "Judaism", "Other"}
insetaxes = [0.2, 0.7, 0.3, 0.2]
insetxlim = [-2, 0]
insetylim = [-0.5, 1.5]
insetxticks = [-2.0, -1.0, 0]
insetyticks = [-0.5, 0.5, 1.5]
arrowstart = (-3.0, 6.0)
arrowend = (0.38, 0.5)
annotaterecx = [-2, 0]
annotaterecy = [-0.5, 1.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

for cluster, data in clusters.items():
    ax.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, label=cluster, edgecolors="w", s=100)

# Annotate main plot area
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[1], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[0], annotaterecy[0]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[0]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[1], annotaterecx[1]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(insetaxes)
for cluster, data in clusters.items():
    ax_inset.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, edgecolors="w", s=50)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Adding annotation arrow
ax.annotate(
    "",
    xy=arrowstart,
    xytext=arrowend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1),
)

# Set axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper right",bbox_to_anchor=(1.2, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_47.pdf", bbox_inches="tight")
