
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Economic data for GDP Growth Rate and Unemployment Rate
import numpy as np

np.random.seed(42)
gdp_region_a = np.random.normal(3.5, 0.5, 10)
unemployment_region_a = np.random.normal(4.5, 1.0, 10)
gdp_region_b = np.random.normal(2.0, 0.3, 10)
unemployment_region_b = np.random.normal(7.0, 1.2, 10)
gdp_region_ab = np.concatenate([gdp_region_a, gdp_region_b])
unemployment_region_ab = np.concatenate([unemployment_region_a, unemployment_region_b])

gdp_region_c = np.random.normal(4.0, 0.4, 5)
unemployment_region_c = np.random.normal(3.0, 0.8, 5)
gdp_region_d = np.random.normal(2.5, 0.6, 5)
unemployment_region_d = np.random.normal(6.5, 0.9, 5)

# Labels and plot limits
xlabel = "GDP Growth Rate (%)"
ylabel = "Unemployment Rate (%)"
title = "Economic Overview: GDP Growth vs. Unemployment"
ax1xlim = [1.5, 5.0]
ax1ylim = [2.0, 9.0]
main_diff_line = [[2.0, 2.0], [1.5, 5.0], [2.0, 9.0]]
inset_diff_line = [[2.0, 2.0], [1.8, 4.2], [3.0, 7.5]]
annotation_rect_x = [1.8, 4.2]
annotation_rect_y = [3.0, 7.5]
ax2xlim = [1.8, 4.2]
ax2ylim = [3.0, 7.5]
main_plot_upper = [1.8, 7.5]
main_plot_lower = [1.8, 3.0]

labels = ["Regions A & B", "Region C", "Region D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
# Scatter plots
ax1.scatter(
    gdp_region_ab, unemployment_region_ab, marker="^", color="#2a9d8f", label=labels[0]
)
ax1.scatter(gdp_region_c, unemployment_region_c, marker="o", color="#e76f51", label=labels[1])
ax1.scatter(gdp_region_d, unemployment_region_d, marker="s", color="#f4a261", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[4.5, ax1ylim[1]], x1=ax1xlim[0], x2=3.0, color="blue", alpha=0.2)
ax1.fill_betweenx(y=[4.5, ax1ylim[0]], x1=3.0, x2=ax1xlim[1], color="yellow", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="black", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="black", lw=0.5)

ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[1], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[0]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[1], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)

# Scatter plots
ax2.scatter(gdp_region_ab, unemployment_region_ab, marker="^", color="#2a9d8f")
ax2.scatter(gdp_region_c, unemployment_region_c, marker="o", color="#e76f51")
ax2.scatter(gdp_region_d, unemployment_region_d, marker="s", color="#f4a261")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 4.5], x1=ax2xlim[0], x2=3.0, color="blue", alpha=0.2)
ax2.fill_betweenx(y=[4.5, ax2ylim[0]], x1=3.0, x2=ax2xlim[1], color="yellow", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="black", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_54.pdf", bbox_inches="tight")
