
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Economics data for housing prices and interest rates
import numpy as np

np.random.seed(0)
# Housing prices (in $1000) and interest rates (%) for different regions
prices_region_a = np.random.normal(300, 20, 10)  # Housing prices (Region A)
rates_region_a = np.random.normal(3.5, 0.5, 10)  # Interest rates (Region A)
prices_region_b = np.random.normal(400, 25, 10)  # Housing prices (Region B)
rates_region_b = np.random.normal(4.0, 0.6, 10)  # Interest rates (Region B)
prices_region_ab = np.concatenate([prices_region_a, prices_region_b])
rates_region_ab = np.concatenate([rates_region_a, rates_region_b])

# Housing prices and interest rates for smaller regions
prices_region_c = np.random.normal(350, 22, 5)  # Housing prices (Region C)
rates_region_c = np.random.normal(3.8, 0.4, 5)  # Interest rates (Region C)
prices_region_d = np.random.normal(320, 18, 5)  # Housing prices (Region D)
rates_region_d = np.random.normal(3.6, 0.3, 5)  # Interest rates (Region D)

# Labels and plot limits
xlabel = "Housing Prices ($1000)"
ylabel = "Interest Rates (%)"
title = "Housing Prices vs Interest Rates in Different Regions"
suptitle = "Economic Analysis of Housing Market"
labels = ["Region A & B", "Region C", "Region D"]

ax1_xlim = [250, 450]
ax1_ylim = [2.5, 5.0]
main_diff_line = [[2.5, 2.5], [250, 450], [2.5, 5.0]]
inset_diff_line = [[2.5, 2.5], [280, 420], [3.0, 4.5]]
annotation_rect_x = [280, 420]
annotation_rect_y = [3.0, 4.5]
ax2_xlim = [280, 420]
ax2_ylim = [3.0, 4.5]
main_plot_upper = [280, 4.5]
main_plot_lower = [280, 3.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(suptitle, fontsize=14)

# Scatter plots
ax1.scatter(prices_region_ab, rates_region_ab, marker="^", color="mediumseagreen", label=labels[0])
ax1.scatter(prices_region_c, rates_region_c, marker="o", color="coral", label=labels[1])
ax1.scatter(prices_region_d, rates_region_d, marker="s", color="royalblue", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[3.5, ax1_ylim[1]], x1=ax1_xlim[0], x2=350, color="lightblue", alpha=0.3)
ax1.fill_betweenx(y=[3.5, ax1_ylim[0]], x1=350, x2=ax1_xlim[1], color="lightgreen", alpha=0.3)

# Axis limits and aspect ratio
ax1.set_xlim(ax1_xlim)
ax1.set_ylim(ax1_ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="black", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="black", lw=0.5)

# Annotation rectangle
ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[1], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[0]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[0]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[1], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title)

# Scatter plots for inset
ax2.scatter(prices_region_ab, rates_region_ab, marker="^", color="mediumseagreen")
ax2.scatter(prices_region_c, rates_region_c, marker="o", color="coral")
ax2.scatter(prices_region_d, rates_region_d, marker="s", color="royalblue")

# Shaded regions for inset
ax2.fill_betweenx(y=[ax2_ylim[1], 3.5], x1=ax2_xlim[0], x2=350, color="lightblue", alpha=0.3)
ax2.fill_betweenx(y=[3.5, ax2_ylim[0]], x1=350, x2=ax2_xlim[1], color="lightgreen", alpha=0.3)

# Axis limits and aspect ratio for inset
ax2.set_xlim(ax2_xlim)
ax2.set_ylim(ax2_ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="black", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(plt.Line2D((main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"))
fig.add_artist(plt.Line2D((main_plot_down[0], inset_down[0]), (main_plot_down[1], inset_down[1]), color="gray"))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_55.pdf", bbox_inches="tight")
