# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle

# ===================
# Part 2: Data Preparation
# ===================
# Political Campaign Performance
import numpy as np

np.random.seed(0)
x_partyA = np.random.normal(10, 2, 10)  # Public Support Increase (Party A)
y_partyA = np.random.normal(50, 10, 10)  # Campaign Funds Raised (Party A)

x_partyB = np.random.normal(15, 3, 10)  # Public Support Increase (Party B)
y_partyB = np.random.normal(55, 12, 10)  # Campaign Funds Raised (Party B)

x_partyC = np.random.normal(20, 4, 10)  # Public Support Increase (Party C)
y_partyC = np.random.normal(60, 15, 10)  # Campaign Funds Raised (Party C)

# Axis labels and limits
xlabel = "Public Support Increase (%)"
ylabel = "Campaign Funds Raised (million $)"
ax1xlim = [0, 30]
ax1ylim = [20, 80]
ax2xlim = [5, 25]
ax2ylim = [40, 70]
diffline1 = [[0, 0], [5, 25], [20, 80]]
diffline2 = [[0, 0], [5, 25], [40, 70]]
title1 = "Overall Political Campaign Performance"
title2 = "Zoom-in View"
label = ["Party A", "Party B", "Party C"]
plot_up1 = [5, 40]
plot_down1 = [5, 73]

labels = ["Party A", "Party B", "Party C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(x_partyA, y_partyA, marker="o", color="#FF5733", label=labels[0])
ax1.scatter(x_partyB, y_partyB, marker="s", color="#33FF57", label=labels[1])
ax1.scatter(x_partyC, y_partyC, marker="^", color="#3357FF", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="#FFD700", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper left")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Rectangle on main plot
rect_main = Rectangle((5, 40), 20, 30, linewidth=1, edgecolor="black", facecolor="none")
ax1.add_patch(rect_main)

# Scatter plots for zoom-in view
ax2.scatter(x_partyA, y_partyA, marker="o", color="#FF5733", label=label[0])
ax2.scatter(x_partyB, y_partyB, marker="s", color="#33FF57", label=label[1])
ax2.scatter(x_partyC, y_partyC, marker="^", color="#3357FF", label=label[2])

# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=5, x2=ax2xlim[1], color="#FFD700", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_57.pdf", bbox_inches="tight")
