# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np
from matplotlib.patches import Rectangle

# ===================
# Part 2: Data Preparation
# ===================
# Environmental Metrics
np.random.seed(42)
x_co2_reduction = np.random.normal(25, 5, 10)  # CO2 Reduction (Year 1)
y_co2_reduction = np.random.normal(40, 10, 10)  # CO2 Reduction (Year 2)

x_renewable_energy = np.random.normal(35, 7, 10)  # Renewable Energy Adoption (Year 1)
y_renewable_energy = np.random.normal(50, 12, 10)  # Renewable Energy Adoption (Year 2)

x_ev_usage = np.random.normal(30, 6, 10)  # Electric Vehicle Usage (Year 1)
y_ev_usage = np.random.normal(45, 11, 10)  # Electric Vehicle Usage (Year 2)

# Axis labels and limits
xlabel = "Year 1 Improvement (%)"
ylabel = "Year 2 Improvement (%)"
ax1xlim = [10, 50]
ax1ylim = [20, 70]
ax2xlim = [20, 40]
ax2ylim = [30, 60]
diffline1 = [[0, 0], [10, 50], [20, 70]]
diffline2 = [[0, 0], [20, 40], [30, 60]]
title1 = "Environmental Metrics Improvement"
title2 = "Zoom-in View"
label = ["CO2 Reduction", "Renewable Energy", "EV Usage"]
plot_up1 = [20, 30]
plot_down1 = [20, 62]

labels = ["CO2 Reduction", "Renewable Energy", "EV Usage"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(
    x_co2_reduction, y_co2_reduction, marker="o", color="#2ca02c", label=labels[0]
)
ax1.scatter(
    x_renewable_energy, y_renewable_energy, marker="s", color="#1f77b4", label=labels[1]
)
ax1.scatter(x_ev_usage, y_ev_usage, marker="^", color="#ff7f0e", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="#d0f0c0", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper left")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Scatter plots for zoom-in view
ax2.scatter(
    x_co2_reduction, y_co2_reduction, marker="o", color="#2ca02c", label=label[0]
)
ax2.scatter(
    x_renewable_energy, y_renewable_energy, marker="s", color="#1f77b4", label=label[1]
)
ax2.scatter(x_ev_usage, y_ev_usage, marker="^", color="#ff7f0e", label=label[2])

# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=0, x2=ax2xlim[1], color="#c6e2ff", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Rectangle on main plot
rect_main = Rectangle(
    (20, 30), 20, 30, linewidth=1, edgecolor="black", facecolor="none"
)
ax1.add_patch(rect_main)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_58.pdf", bbox_inches="tight")
