# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle


# ===================
# Part 2: Data Preparation
# ===================
# AI Algorithms
import numpy as np

np.random.seed(0)
# Solar Energy Adoption
x_solar = np.random.normal(5, 1, 10)  # Adoption Rate (%)
y_solar = np.random.normal(20, 3, 10)  # User Satisfaction (Score)

# Wind Energy Adoption
x_wind = np.random.normal(10, 2, 10)  # Adoption Rate (%)
y_wind = np.random.normal(30, 4, 10)  # User Satisfaction (Score)

# Hydro Energy Adoption
x_hydro = np.random.normal(15, 3, 10)  # Adoption Rate (%)
y_hydro = np.random.normal(25, 5, 10)  # User Satisfaction (Score)

# Axis labels and limits
xlabel = "Adoption Rate (%)"
ylabel = "User Satisfaction (Score)"
ax1xlim = [0, 20]
ax1ylim = [10, 40]
ax2xlim = [5, 15]
ax2ylim = [15, 35]
diffline1 = [[0, 0], [5, 20], [20, 30]]
diffline2 = [[0, 0], [5, 15], [15, 35]]
title1 = "Adoption of Renewable Energy Sources"
title2 = "Zoom-in View of Adoption Rates"
plot_up1 = [5, 15]
plot_down1 = [5, 35]

labels = ["Solar Energy", "Wind Energy", "Hydro Energy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(x_solar, y_solar, marker="o", color="orange", label=labels[0])
ax1.scatter(x_wind, y_wind, marker="s", color="blue", label=labels[1])
ax1.scatter(x_hydro, y_hydro, marker="^", color="green", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="lightgray", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Rectangle on main plot
rect_main = Rectangle((5, 15), 10, 20, linewidth=1, edgecolor="black", facecolor="none")
ax1.add_patch(rect_main)

# Scatter plots for zoom-in view
ax2.scatter(x_solar, y_solar, marker="o", color="orange", label=labels[0])
ax2.scatter(x_wind, y_wind, marker="s", color="blue", label=labels[1])
ax2.scatter(x_hydro, y_hydro, marker="^", color="green", label=labels[2])


# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=4, x2=ax2xlim[1], color="lightgreen", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Coordinates of the main plot corners
# Coordinates of the inset corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_59.pdf", bbox_inches="tight")
