# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate tourism data
domestic_tourists = [
    100,
    150,
    200,
    250,
    300,
    350,
    400,
    450,
    500,
    550,
    600,
]  # Domestic Tourists (in thousands)
international_tourists = [
    500,
    700,
    1000,
    1200,
    1500,
    1800,
    2000,
    2200,
    2400,
    2600,
    2800,
]  # International Tourists (in thousands)
years = [i for i in range(11)]
labels = ["Domestic Tourists", "International Tourists"]
xmainlabel = "Year"
xmainlim = [-0.5, 10.5]
xmainticks = [i for i in range(11)]
ymainlabel = "Number of Tourists (in thousands)"
ymainlim = [0, 10000]
ymainticks = [i * 1000 for i in range(11)]

xinsetlim = [5.5, 10.5]
xinsetticks = [6, 7, 8, 9, 10]
yinsetlim = [0, 7000]
yinsetticks = [i * 1000 for i in range(8)]

# Coordinates for lines connecting the plots (main and inset)
mainplotline = [(5.5, 0), (10.5, 0)]
maininsetline = [(6, 0), (10, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.4  # Adjusted bar width
ax_main.bar(
    years,
    domestic_tourists,
    width=bar_width,
    color="#ffa726",  # Orange for Domestic Tourists
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    years,
    international_tourists,
    width=bar_width,
    color="#42a5f5",  # Light Blue for International Tourists
    align="center",
    bottom=domestic_tourists,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper left", prop={"size": 12})

# Inset plot configuration
ax_inset = fig.add_axes([0.55, 0.5, 0.35, 0.4])
ax_inset.bar(
    years[6:],
    domestic_tourists[6:],
    width=bar_width,
    color="#ffa726",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    years[6:],
    international_tourists[6:],
    width=bar_width,
    color="#42a5f5",
    align="center",
    bottom=domestic_tourists[6:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_68.pdf", bbox_inches="tight")
