
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# --------------------
# Part 2: Data Preparation
# --------------------
import numpy as np

# Simulated Data for Game Artistry Trends
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
gallery_visitors = np.array([12000, 13500, 14500, 16000, 17500, 21000])  # Increasing trend for gallery visitors
painting_sales = np.array([400, 550, 600, 780, 900, 1250])  # Increasing trend for painting sales

# Styling
labels = [
    "Art Gallery Visitors",
    "Painting Sales"
]
xlabel = "Year"
ylabel = "Count"
title = "Art Gallery Visitors and Painting Sales (2010-2020)"

# Labels and tick mark settings
xticks = years
yticks = np.linspace(0, 22000, 6)
yticklabels = [f"{int(x):,}" for x in yticks]
inset_axes = [0.6, 0.3, 0.3, 0.3]
inset_ylim = [0, 1300]
yticks_inset = np.linspace(0, 1300, 6)
x_years = [f"{int(x)}" for x in years]

# --------------------
# Part 3: Plot Configuration and Rendering
# --------------------
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data with different styles and colors
ax.plot(years, gallery_visitors, "o-", label=labels[0], color="#FF5733", linewidth=2, markersize=8)
ax.plot(years, painting_sales, "x--", label=labels[1], color="#C70039", linewidth=2, markersize=8)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Adjust y-axis limits and ticks
ax.set_ylim([0, 22000])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels, fontsize=10)

# Add a legend
ax.legend(loc="upper left", fontsize=10)

# Create an inset axis for painting sales
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, painting_sales, "x--", color="#C70039", linewidth=2, markersize=8)

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2010, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years, fontsize=10)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(x_years, fontsize=8)

# --------------------
# Part 4: Saving Output
# --------------------
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_71.pdf", bbox_inches="tight")
