# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated data for cumulative artworks created by four artists over a 38-week period
np.random.seed(0)
x = np.linspace(1, 38, 38)
y1 = np.cumsum(np.random.poisson(1.5, 38))  # Artist A
y2 = np.cumsum(np.random.poisson(1.8, 38))  # Artist B
y3 = np.cumsum(np.random.poisson(1.2, 38))  # Artist C
y4 = np.cumsum(np.random.poisson(1.4, 38))  # Artist D

# Labels and Plot Types
label_ArtistA = "Artist A"
label_ArtistB = "Artist B"
label_ArtistC = "Artist C"
label_ArtistD = "Artist D"

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Cumulative Artworks Created"
zoomed_in_axes = [0.20, 0.6, 0.25, 0.25]
xlim_values = [33, 38]
ylim_values = [y1[32], max(y1[37], y2[37], y3[37], y4[37]) + 2]
xticks_values = [33, 35, 37]
yticks_values = list(range(int(ylim_values[0]), int(ylim_values[1]) + 5, 5))
title = "Artworks Created Over 38 Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the curves with distinct styles
ax.plot(
    x, y1, color="#FF5733", linestyle="-", linewidth=2, marker="o", label=label_ArtistA
)
ax.plot(
    x, y2, color="#33FF57", linestyle="--", linewidth=2, marker="s", label=label_ArtistB
)
ax.plot(
    x, y3, color="#3357FF", linestyle="-.", linewidth=2, marker="^", label=label_ArtistC
)
ax.plot(
    x, y4, color="#F333FF", linestyle=":", linewidth=2, marker="d", label=label_ArtistD
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Add grid
ax.grid(True, linestyle="--", linewidth=0.5)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(
    zoomed_in_axes
)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(x, y1, color="#FF5733", linestyle="-", linewidth=2)
ax_inset.plot(x, y2, color="#33FF57", linestyle="--", linewidth=2)
ax_inset.plot(x, y3, color="#3357FF", linestyle="-.", linewidth=2)
ax_inset.plot(x, y4, color="#F333FF", linestyle=":", linewidth=2)
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_74.pdf", bbox_inches="tight")
