
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting (Business Metrics over time)
x = [1, 2, 3, 4, 5]
revenue = [100, 150, 200, 250, 300]
cost = [80, 110, 130, 160, 190]
profit = [20, 40, 70, 90, 110]
market_share = [5, 8, 12, 15, 18]

# Labels for legend
label_revenue = "Revenue"
label_cost = "Cost"
label_profit = "Profit"
label_market_share = "Market Share (%)"

# Horizontal line value
axhline_value = 200

# Axis labels and title
xlabel_values = ["Q1", "Q2", "Q3", "Q4", "Q5"]
ylabel_values = [0, 50, 100, 150, 200, 250, 300]
ylabel = "Value in USD (thousands)"
title = "Quarterly Business Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size to match original image dimensions

# Plot limits
xlim_values = (1, 5)
ylim_values = (0, 320)

# Axis ticks
xticks_values = x
yticks_values = ylabel_values

# Plot lines
plt.plot(
    x,
    revenue,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=8,
    color="#1f77b4",
    label=label_revenue,
)
plt.plot(
    x,
    cost,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f0e",
    markeredgecolor="#ff7f0e",
    markersize=8,
    color="#ff7f0e",
    label=label_cost,
)
plt.plot(
    x,
    profit,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=8,
    color="#2ca02c",
    label=label_profit,
)
plt.plot(
    x,
    market_share,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d62728",
    markeredgecolor="#d62728",
    markersize=8,
    color="#d62728",
    label=label_market_share,
)

# Filling the area under the curves

plt.fill_between(x, revenue, cost, color="#1f77b4", alpha=0.3)
plt.fill_between(x, cost, profit, color="#ff7f0e", alpha=0.3)
plt.fill_between(x, profit, market_share, color="#2ca02c", alpha=0.3)
plt.fill_between(x, market_share, 0, color="#d62728", alpha=0.3)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis、y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding labels and title
plt.xlabel("Quarter")
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_22.pdf", bbox_inches="tight")
