
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data representing voting trends
time_step = np.linspace(0, 4, 40)
party_a_voting = np.cos(time_step) + 2
party_b_voting = np.sin(0.7 * time_step) + 2
party_c_voting = np.sin(0.5 * time_step) + 2

# Sample data representing approval ratings
party_a_approval = 0.6 + 0.02 * np.cos(0.5 * time_step)
party_b_approval = 0.5 + 0.02 * np.sin(0.5 * time_step)
party_c_approval = 0.4 + 0.02 * np.cos(0.8 * time_step)

# Extracted variables
party_a_label = "Party A"
party_b_label = "Party B"
party_c_label = "Party C"

voting_ylabel = "Voting Trends"
approval_xlabel = "Time Step"
approval_ylabel = "Approval Ratings"
legend_labels = ["Party A", "Party B", "Party C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Voting Trends Plot Configuration
voting_ylim = [0, 4]
voting_xlim = [0, 4]
voting_yticks = [0, 1, 2, 3, 4]
voting_xticks = [0, 1, 2, 3, 4]

# Approval Ratings Plot Configuration
approval_ylim = [0.38, 0.62]
approval_xlim = [0, 4]
approval_yticks = [0.38, 0.44, 0.5, 0.56, 0.62]
approval_xticks = [0, 1, 2, 3, 4]

# Plot Voting Trends
ax1.plot(time_step, party_a_voting, "o--", color="#FF5733", label=party_a_label)
ax1.fill_between(time_step, party_a_voting, color="#FDEDEC")
ax1.plot(time_step, party_b_voting, "s--", color="#33FFCE", label=party_b_label)
ax1.fill_between(time_step, party_b_voting, color="#E0F7F1")
ax1.plot(time_step, party_c_voting, "^-.", color="#335BFF", label=party_c_label)
ax1.fill_between(time_step, party_c_voting, color="#EDEEFF")
ax1.set_ylim(voting_ylim)
ax1.set_xlim(voting_xlim)
ax1.set_yticks(voting_yticks)
ax1.set_xticks(voting_xticks)
ax1.set_ylabel(voting_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Approval Ratings
ax2.plot(time_step, party_a_approval, "o--", color="#FF5733", label=party_a_label)
ax2.fill_between(time_step, party_a_approval, color="#FDEDEC")
ax2.plot(time_step, party_b_approval, "s--", color="#33FFCE", label=party_b_label)
ax2.fill_between(time_step, party_b_approval, color="#E0F7F1")
ax2.plot(time_step, party_c_approval, "^-.", color="#335BFF", label=party_c_label)
ax2.fill_between(time_step, party_c_approval, color="#EDEEFF")
ax2.set_ylim(approval_ylim)
ax2.set_xlim(approval_xlim)
ax2.set_yticks(approval_yticks)
ax2.set_xticks(approval_xticks)
ax2.set_xlabel(approval_xlabel)
ax2.set_ylabel(approval_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
party_a_line = mlines.Line2D(
    [], [], color="#FF5733", marker="o", markersize=6, label=legend_labels[0]
)
party_b_line = mlines.Line2D(
    [], [], color="#33FFCE", marker="s", markersize=6, label=legend_labels[1]
)
party_c_line = mlines.Line2D(
    [], [], color="#335BFF", marker="^", markersize=6, label=legend_labels[2]
)
plt.legend(
    handles=[party_a_line, party_b_line, party_c_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=6,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_24.pdf", bbox_inches="tight")
