
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time_step = np.linspace(2000, 2040, 40)
pop_region1 = 5e6 * np.exp(0.02 * (time_step - 2000))
pop_region2 = 3e6 * np.exp(0.03 * (time_step - 2000))
pop_region3 = 4e6 * np.exp(0.025 * (time_step - 2000))
density_region1 = 100 + 0.5 * (time_step - 2000)
density_region2 = 150 + 0.3 * (time_step - 2000)
density_region3 = 120 + 0.4 * (time_step - 2000)

# Extracted variables
pop_label_region1 = "Region 1"
pop_label_region2 = "Region 2"
pop_label_region3 = "Region 3"
density_label_region1 = "Region 1"
density_label_region2 = "Region 2"
density_label_region3 = "Region 3"

pop_ylabel = "Population (millions)"
density_xlabel = "Year"
density_ylabel = "Population Density (per km²)"
legend_labels = ["Region 1", "Region 2", "Region 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

pop_ylim = [0, 12e6]
pop_xlim = [2000, 2040]
pop_yticks = np.arange(0, 13e6, 2e6)
pop_xticks = np.arange(2000, 2041, 10)

density_ylim = [95, 160]
density_xlim = [2000, 2040]
density_yticks = np.arange(95, 165, 10)
density_xticks = np.arange(2000, 2041, 10)

# Plot Population Growth
ax1.plot(time_step, pop_region1, "o-", color="#1f77b4", label=pop_label_region1)
ax1.fill_between(time_step, pop_region1, color="#aec7e8", alpha=0.5)
ax1.plot(time_step, pop_region2, "s--", color="#ff7f0e", label=pop_label_region2)
ax1.fill_between(time_step, pop_region2, color="#ffbb78", alpha=0.5)
ax1.plot(time_step, pop_region3, "^-", color="#2ca02c", label=pop_label_region3)
ax1.fill_between(time_step, pop_region3, color="#98df8a", alpha=0.5)
ax1.set_ylim(pop_ylim)
ax1.set_xlim(pop_xlim)
ax1.set_yticks(pop_yticks)
ax1.set_xticks(pop_xticks)
ax1.set_ylabel(pop_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.set_title("Population Growth")

# Plot Population Density
ax2.plot(time_step, density_region1, "o-", color="#1f77b4", label=density_label_region1)
ax2.fill_between(time_step, density_region1, color="#aec7e8", alpha=0.5)
ax2.plot(time_step, density_region2, "s--", color="#ff7f0e", label=density_label_region2)
ax2.fill_between(time_step, density_region2, color="#ffbb78", alpha=0.5)
ax2.plot(time_step, density_region3, "^-", color="#2ca02c", label=density_label_region3)
ax2.fill_between(time_step, density_region3, color="#98df8a", alpha=0.5)
ax2.set_ylim(density_ylim)
ax2.set_xlim(density_xlim)
ax2.set_yticks(density_yticks)
ax2.set_xticks(density_xticks)
ax2.set_xlabel(density_xlabel)
ax2.set_ylabel(density_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.set_title("Population Density")

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="o", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="s", markersize=6, label=legend_labels[1]
)
green_line = mlines.Line2D(
    [], [], color="#2ca02c", marker="^", markersize=6, label=legend_labels[2]
)
plt.legend(
    handles=[blue_line, orange_line, green_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=3,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_25.pdf", bbox_inches="tight")

