
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time_step = np.linspace(0, 10, 100)
as_car = 40 + 10 * np.sin(time_step / 2)
as_bus = 30 + 8 * np.sin(time_step / 2 + 1)
as_bicycle = 15 + 5 * np.sin(time_step / 2 + 2)
fe_car = 20 + np.cos(time_step / 2)
fe_bus = 15 + np.cos(time_step / 2 + 1)
fe_bicycle = 50 + np.cos(time_step / 2 + 2)

# Extracted variables
as_car_label = "Car"
as_bus_label = "Bus"
as_bicycle_label = "Bicycle"
fe_car_label = "Car"
fe_bus_label = "Bus"
fe_bicycle_label = "Bicycle"

as_ylabel = "Average Speed (km/h)"
fe_xlabel = "Time (h)"
fe_ylabel = "Fuel Efficiency (km/l)"
legend_labels = ["Car", "Bus", "Bicycle"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

as_ylim = [0, 60]
as_xlim = [0, 10]
as_yticks = [0, 10, 20, 30, 40, 50, 60]
as_xticks = [0, 2, 4, 6, 8, 10]

fe_ylim = [0, 60]
fe_xlim = [0, 10]
fe_yticks = [0, 10, 20, 30, 40, 50, 60]
fe_xticks = [0, 2, 4, 6, 8, 10]

# Plot Average Speed
ax1.plot(time_step, as_car, "o-", color="#FFA500", label=as_car_label)
ax1.fill_between(time_step, as_car, color="#FFF0E0")
ax1.plot(time_step, as_bus, "s-", color="#4682B4", label=as_bus_label)
ax1.fill_between(time_step, as_bus, color="#D7E3F5")
ax1.plot(time_step, as_bicycle, "^-", color="#32CD32", label=as_bicycle_label)
ax1.fill_between(time_step, as_bicycle, color="#E2F0E2")
ax1.set_ylim(as_ylim)
ax1.set_xlim(as_xlim)
ax1.set_yticks(as_yticks)
ax1.set_xticks(as_xticks)
ax1.set_ylabel(as_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Fuel Efficiency
ax2.plot(time_step, fe_car, "o-", color="#FFA500", label=fe_car_label)
ax2.fill_between(time_step, fe_car, color="#FFF0E0")
ax2.plot(time_step, fe_bus, "s-", color="#4682B4", label=fe_bus_label)
ax2.fill_between(time_step, fe_bus, color="#D7E3F5")
ax2.plot(time_step, fe_bicycle, "^-", color="#32CD32", label=fe_bicycle_label)
ax2.fill_between(time_step, fe_bicycle, color="#E2F0E2")
ax2.set_ylim(fe_ylim)
ax2.set_xlim(fe_xlim)
ax2.set_yticks(fe_yticks)
ax2.set_xticks(fe_xticks)
ax2.set_xlabel(fe_xlabel)
ax2.set_ylabel(fe_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
orange_line = mlines.Line2D([], [], color="#FFA500", marker="o", markersize=6, label=legend_labels[0])
blue_line = mlines.Line2D([], [], color="#4682B4", marker="s", markersize=6, label=legend_labels[1])
green_line = mlines.Line2D([], [], color="#32CD32", marker="^", markersize=6, label=legend_labels[2])
plt.legend(handles=[orange_line, blue_line, green_line], loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_26.pdf", bbox_inches="tight")
