
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plot with climate trends
decomposition_IO_norm = np.array([0, 20, 40, 60, 80])
cooler_region = np.array([10, 12, 13, 14, 15]) + np.array(
    [0.5, -0.3, 0.1, 0.2, -0.1]
)  # Small noise for realism
moderate_region = np.array([15, 17, 18, 19, 20]) + np.array(
    [-0.2, 0.2, -0.1, 0.3, -0.2]
)
warmer_region1 = np.array([20, 22, 24, 25, 26])  # Trend for a warmer region
warmer_region2 = np.array([22, 23, 25, 26, 27])  # Slightly different warmer trend
global_avg = np.linspace(18, 18, len(decomposition_IO_norm))  # Constant global average

# Extracted variables
fill_label_cooler = "Cooler Region"
fill_label_moderate = "Moderate Region"
fill_label_warmer1 = "Warmer Region 1"
fill_label_warmer2 = "Warmer Region 2"
plot_label_global_avg = "Global Average Temp"
title_text = "Temperature Variations Across Regions"
xlabel_text = "Decomposition IO Norm"
ylabel_text = "Temperature (°C)"
legend_title = "Regions"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))

xlim_values = (min(decomposition_IO_norm), max(decomposition_IO_norm))
ylim_values = (8, 28)
xticks_values = decomposition_IO_norm
yticks_values = [8, 10, 15, 20, 25, 28]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.12)
legend_ncol = 5

plt.fill_between(
    decomposition_IO_norm, cooler_region, color="#1f77b4", alpha=0.3, label=fill_label_cooler
)
plt.fill_between(
    decomposition_IO_norm,
    moderate_region,
    color="#2ca02c",
    alpha=0.3,
    label=fill_label_moderate,
)
plt.fill_between(
    decomposition_IO_norm, warmer_region1, color="#ff7f0e", alpha=0.3, label=fill_label_warmer1
)
plt.fill_between(
    decomposition_IO_norm,
    warmer_region2,
    color="#d62728",
    alpha=0.3,
    label=fill_label_warmer2,
)
plt.plot(
    decomposition_IO_norm,
    global_avg,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_global_avg,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_27.pdf", bbox_inches="tight")
